package io.ultreia.java4all.i18n.editor.action;

/*-
 * #%L
 * JAXX :: I18n Editor
 * %%
 * Copyright (C) 2008 - 2024 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.i18n.editor.ui.ItemComponent;
import io.ultreia.java4all.i18n.editor.ui.ItemComponentTab;

/**
 * Created by tchemit on 09/07/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class FilterKeysAction extends ItemActionSupport {
    private boolean adjusting;

    public FilterKeysAction(ItemComponent itemComponent) {
        super(itemComponent,
              "Filter",
              "Modified or to fix items vs All items",
              (int) 'M',
              "filter");
    }

    @Override
    protected boolean doAction(ItemComponent itemComponent) {

        if (adjusting) {
            return false;
        }
        adjusting = true;
        try {
            boolean add = itemComponent.getFilter().isSelected();
            itemComponent.updateListFromFilter(add);

            for (ItemComponentTab tab : itemComponent.getTabs()) {
                tab.updateListFromFilter(add);
            }
            ItemComponentTab tab = itemComponent.getCurrentTab();
            tab.clearSelection();
            if (tab.isNotEmpty()) {
                tab.setSelectedIndex(0);
            }
        } finally {
            adjusting = false;
        }
        return true;
    }
}
