/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json;

import io.ultreia.java4all.util.json.JsonAdapter;
import io.ultreia.java4all.util.json.JsonHierarchicAdapter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonAdapterProvider {
    private static final Logger log = LogManager.getLogger(JsonAdapterProvider.class);
    private static JsonAdapterProvider INSTANCE;
    private final Map<Class<?>, JsonAdapter> adapters;
    private final Map<Class<?>, JsonHierarchicAdapter> hierarchicAdapters;

    public static JsonAdapterProvider get() {
        return INSTANCE == null ? (INSTANCE = new JsonAdapterProvider()) : INSTANCE;
    }

    public static void offers(BiConsumer<Class<?>, JsonAdapter> adapterConsumer, BiConsumer<Class<?>, JsonHierarchicAdapter> hierarchicAdapterConsumer) {
        JsonAdapterProvider provider = JsonAdapterProvider.get();
        provider.adapters.forEach(adapterConsumer);
        provider.hierarchicAdapters.forEach(hierarchicAdapterConsumer);
    }

    private JsonAdapterProvider() {
        Class<?> type;
        LinkedHashMap adapters = new LinkedHashMap();
        LinkedHashMap hierarchicAdapters = new LinkedHashMap();
        for (JsonAdapter jsonAdapter : ServiceLoader.load(JsonAdapter.class)) {
            type = jsonAdapter.type();
            log.info(String.format("Found json type: %s (%s)", type.getName(), jsonAdapter));
            adapters.put(type, jsonAdapter);
        }
        for (JsonHierarchicAdapter jsonHierarchicAdapter : ServiceLoader.load(JsonHierarchicAdapter.class)) {
            type = jsonHierarchicAdapter.type();
            log.info(String.format("Found hierarchic json type: %s (%s)", type.getName(), jsonHierarchicAdapter));
            hierarchicAdapters.put(type, jsonHierarchicAdapter);
        }
        this.adapters = Collections.unmodifiableMap(adapters);
        this.hierarchicAdapters = Collections.unmodifiableMap(hierarchicAdapters);
    }
}

