/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zips {
    private static final int BUFFER_SIZE = 8192;

    public static void uncompress(InputStream stream, File targetDir) throws IOException {
        Zips.uncompressAndRename(stream, targetDir, null, null);
    }

    public static void uncompressAndRename(InputStream stream, File targetDir, String renameFrom, String renameTo) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(stream));){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                String name = entry.getName();
                if (renameFrom != null && renameTo != null) {
                    name = name.replaceAll(renameFrom, renameTo);
                }
                File target = new File(targetDir, name);
                if (entry.isDirectory()) {
                    Zips.createDirectoryIfNecessary(target);
                    continue;
                }
                Zips.createDirectoryIfNecessary(target.getParentFile());
                try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));){
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer, 0, 8192)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
            }
        }
    }

    public static void uncompressFiltred(File file, File targetDir, String ... excludes) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            boolean excludeEntry = false;
            if (excludes != null) {
                for (String exclude : excludes) {
                    if (!name.matches(exclude)) continue;
                    excludeEntry = true;
                }
            }
            if (excludeEntry) continue;
            File target = new File(targetDir, name);
            if (entry.isDirectory()) {
                Zips.createDirectoryIfNecessary(target);
                continue;
            }
            Zips.createDirectoryIfNecessary(target.getParentFile());
            InputStream in = zipFile.getInputStream(entry);
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));){
                int len;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer, 0, 8192)) != -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public static void createDirectoryIfNecessary(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static boolean isZipFile(File file) {
        boolean result = false;
        try {
            ZipFile zipFile = new ZipFile(file);
            zipFile.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void compressFiles(File zipFile, File root, Collection<File> includes) throws IOException {
        try (FileOutputStream oStream = new FileOutputStream(zipFile);
             ZipOutputStream zipOStream = new ZipOutputStream(oStream);){
            for (File file : includes) {
                String entryName = Zips.toZipEntryName(root, file);
                ZipEntry entry = new ZipEntry(entryName);
                entry.setTime(file.lastModified());
                zipOStream.putNextEntry(entry);
                if (file.isFile() && file.canRead()) {
                    byte[] readBuffer = new byte[8192];
                    try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 8192);){
                        int bytesIn;
                        while ((bytesIn = bis.read(readBuffer, 0, 8192)) != -1) {
                            zipOStream.write(readBuffer, 0, bytesIn);
                        }
                    }
                }
                zipOStream.closeEntry();
            }
        }
    }

    private static String toZipEntryName(File root, File file) {
        String rootPath;
        Object result = file.getPath();
        if (root != null && ((String)result).startsWith(rootPath = root.getPath())) {
            result = ((String)result).substring(rootPath.length());
        }
        result = ((String)result).replace('\\', '/');
        if (file.isDirectory()) {
            result = (String)result + "/";
        }
        while (((String)result).startsWith("/")) {
            result = ((String)result).substring(1);
        }
        return result;
    }
}

