/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class SingletonSupplier<O>
implements Supplier<O> {
    private Supplier<O> supplier;
    private final boolean requireNonNull;
    private O cache;

    protected SingletonSupplier(Supplier<O> supplier, boolean requireNonNull) {
        this.supplier = Objects.requireNonNull(supplier);
        this.requireNonNull = requireNonNull;
    }

    public static <O> SingletonSupplier<O> of(Supplier<O> supplier) {
        return SingletonSupplier.of(supplier, true);
    }

    public static <O> SingletonSupplier<O> of(Supplier<O> supplier, boolean requireNonNull) {
        return new SingletonSupplier<O>(supplier, requireNonNull);
    }

    @Override
    public O get() {
        return this.cache == null ? (this.cache = this.load()) : this.cache;
    }

    public void setSupplier(Supplier<O> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
        this.clear();
    }

    public Optional<O> clear() {
        Optional<O> result = Optional.ofNullable(this.cache);
        this.cache = null;
        return result;
    }

    public boolean withValue() {
        return this.cache != null;
    }

    protected O load() {
        O cache = this.supplier.get();
        if (this.requireNonNull) {
            Objects.requireNonNull(cache, "Value can't not be null if requiredNonNull flag is set on.");
        }
        return cache;
    }
}

