/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters;

import com.google.auto.service.AutoService;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ultreia.java4all.util.json.JsonAdapter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;

@AutoService(value={JsonAdapter.class})
public class ClassAdapter
implements JsonSerializer<Class<?>>,
JsonDeserializer<Class<?>>,
JsonAdapter {
    private static final Map<String, Class<?>> CLASS_CACHE = new TreeMap();

    @Override
    public Class<?> type() {
        return Class.class;
    }

    public JsonElement serialize(Class<?> src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src.getCanonicalName(), String.class);
    }

    public Class<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String className = json.getAsString();
        return CLASS_CACHE.computeIfAbsent(className, k -> this.loadClass(className));
    }

    protected Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Class not found: " + className, (Throwable)e);
        }
    }

    static {
        CLASS_CACHE.put("boolean", Boolean.TYPE);
        CLASS_CACHE.put("byte", Byte.TYPE);
        CLASS_CACHE.put("char", Character.TYPE);
        CLASS_CACHE.put("short", Short.TYPE);
        CLASS_CACHE.put("int", Integer.TYPE);
        CLASS_CACHE.put("long", Long.TYPE);
        CLASS_CACHE.put("float", Float.TYPE);
        CLASS_CACHE.put("double", Double.TYPE);
    }
}

