/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.util.Objects;
import java.util.function.Function;

public class RecursivePropertiesResolver {
    private static final String VARIABLE_START = "${";
    private static final String VARIABLE_END = "}";
    private final String variableStart;
    private final int variableStartLength;
    private final String variableEnd;
    private final int variableEndLength;

    public RecursivePropertiesResolver() {
        this(VARIABLE_START, VARIABLE_END);
    }

    public RecursivePropertiesResolver(String variableStart, String variableEnd) {
        this.variableStart = Objects.requireNonNull(variableStart);
        this.variableStartLength = variableStart.length();
        this.variableEnd = Objects.requireNonNull(variableEnd);
        this.variableEndLength = variableEnd.length();
    }

    public String getProperty(Function<String, String> properties, String key) {
        String result = properties.apply(key);
        if (result == null) {
            return null;
        }
        return this.resolve(properties, result);
    }

    public String resolve(Function<String, String> properties, String key) {
        if (key == null) {
            return null;
        }
        int pos = ((String)key).indexOf(this.variableStart);
        while (pos != -1) {
            int posEnd = ((String)key).indexOf(this.variableEnd, pos + this.variableEndLength);
            if (posEnd == -1) continue;
            String value = this.getProperty(properties, ((String)key).substring(pos + this.variableStartLength, posEnd));
            if (value != null) {
                key = ((String)key).substring(0, pos) + value + ((String)key).substring(posEnd + this.variableEndLength);
                pos = ((String)key).indexOf(this.variableStart, pos + value.length());
                continue;
            }
            pos = ((String)key).indexOf(this.variableStart, posEnd + this.variableEndLength);
        }
        return key;
    }
}

