/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZips {
    public static boolean isGzipStream(InputStream inputStream) throws IOException {
        inputStream.mark(2);
        int b = inputStream.read();
        int magic = inputStream.read() << 8 | b;
        inputStream.reset();
        return magic == 35615;
    }

    public static StringBuffer bytesToStringBuffer(byte[] in) {
        if (in == null || in.length == 0) {
            return new StringBuffer("");
        }
        StringBuffer sb = new StringBuffer();
        try (GZIPInputStream gz = new GZIPInputStream(new BufferedInputStream(new ByteArrayInputStream(in)));){
            int c;
            while ((c = gz.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Can't decompress", e);
        }
        return sb;
    }

    public static String bytesToString(byte[] in) {
        return GZips.bytesToStringBuffer(in).toString();
    }

    public static byte[] stringBufferToBytes(StringBuffer elem) {
        return GZips.stringToBytes(elem.toString());
    }

    public static byte[] stringToBytes(String elem) {
        try {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(new BufferedOutputStream(baos));
            BufferedReader sr = new BufferedReader(new StringReader(elem));
            while ((c = ((Reader)sr).read()) != -1) {
                gz.write((char)c);
            }
            gz.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't compress", e);
        }
    }
}

