/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import io.ultreia.java4all.lang.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class TimeLog {
    protected Logger timeLog;
    protected long timeToLogInfo = 1000000000L;
    protected long timeToLogWarn = 3000000000L;
    protected Map<String, CallStat> callCount = new HashMap<String, CallStat>();

    public static long getTime() {
        return System.nanoTime();
    }

    public TimeLog(String logName) {
        this(LogManager.getLogger((String)(logName + ".TimeLog")));
    }

    public TimeLog(Class<?> logName) {
        this(logName.getName());
    }

    private TimeLog(Logger logTime) {
        this.timeLog = logTime;
    }

    public TimeLog(String logName, long timeToLogInfo, long timeToLogWarn) {
        this(logName);
        this.setTimeToLogInfo(timeToLogInfo);
        this.setTimeToLogWarn(timeToLogWarn);
    }

    public TimeLog(Class<?> logName, long timeToLogInfo, long timeToLogWarn) {
        this(logName.getName(), timeToLogInfo, timeToLogWarn);
    }

    public void setTimeToLogInfo(long timeToLogInfoMs) {
        this.timeToLogInfo = timeToLogInfoMs * 1000000L;
    }

    public void setTimeToLogWarn(long timeToLogWarnMs) {
        this.timeToLogWarn = timeToLogWarnMs * 1000000L;
    }

    public Map<String, CallStat> getCallCount() {
        return this.callCount;
    }

    public long log(long startNs, String methodName) {
        return this.log(startNs, TimeLog.getTime(), methodName, null);
    }

    public long log(long startNs, String methodName, String msg) {
        return this.log(startNs, TimeLog.getTime(), methodName, msg);
    }

    public long log(long startNs, long stopNs, String methodName, String msg) {
        long time = stopNs - startNs;
        CallStat calls = this.callCount.computeIfAbsent(methodName, m -> new CallStat());
        ++calls.callNumber;
        calls.callTime += time;
        if (calls.maxCallTime < time) {
            calls.maxCallTime = time;
        }
        if (calls.minCallTime > time) {
            calls.minCallTime = time;
        }
        LogBuilder logBuilder = null;
        if (time > this.timeToLogWarn && this.timeLog.isWarnEnabled()) {
            logBuilder = this.timeLog.atWarn();
        } else if (time > this.timeToLogInfo && this.timeLog.isInfoEnabled()) {
            logBuilder = this.timeLog.atInfo();
        } else if (this.timeLog.isDebugEnabled()) {
            logBuilder = this.timeLog.atDebug();
        }
        if (logBuilder != null) {
            logBuilder.withLocation(StackLocatorUtil.getStackTraceElement((int)3));
            String message = this.computeLogMessage(methodName, msg, calls, time);
            logBuilder.log(message);
        }
        return stopNs;
    }

    public void reset() {
        this.getCallCount().clear();
    }

    protected String computeLogMessage(String methodName, String msg, CallStat calls, long time) {
        String timeString = Strings.convertTime((long)time);
        return String.format("[%10s] [%s] '%s'%s", timeString, calls, methodName, msg == null || msg.isEmpty() ? "" : " " + msg);
    }

    public static class CallStat {
        protected long callNumber;
        protected long maxCallTime = 0L;
        protected long minCallTime = Integer.MAX_VALUE;
        protected long callTime;

        public String toString() {
            String callTimeString = Strings.convertTime((long)this.callTime);
            String avgTimeString = Strings.convertTime((long)(this.callTime / this.callNumber));
            String minCallTimeString = Strings.convertTime((long)this.minCallTime);
            String maxCallTimeString = Strings.convertTime((long)this.maxCallTime);
            return String.format("%6s %10s %10s %10s %10s", this.callNumber, minCallTimeString, maxCallTimeString, avgTimeString, callTimeString);
        }
    }
}

