/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters;

import com.google.auto.service.AutoService;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.JsonAdapter;
import io.ultreia.java4all.util.sql.BlobsContainer;
import io.ultreia.java4all.util.sql.SqlScript;
import java.lang.reflect.Type;
import java.util.Set;

@AutoService(value={JsonAdapter.class})
public class SqlScriptAdapter
implements JsonDeserializer<SqlScript>,
JsonSerializer<SqlScript>,
JsonAdapter {
    public static final String LOCATION = "location";
    public static final String BLOBS = "blobs";
    private static final Type TYPE = TypeToken.getParameterized(Set.class, (Type[])new Type[]{BlobsContainer.class}).getType();

    @Override
    public Class<?> type() {
        return SqlScript.class;
    }

    public SqlScript deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        byte[] location = (byte[])context.deserialize(jsonObject.get(LOCATION), byte[].class);
        SqlScript result = SqlScript.of(location);
        JsonElement blobsElement = jsonObject.get(BLOBS);
        if (blobsElement != null) {
            Set blobs = (Set)context.deserialize(blobsElement, TYPE);
            result.addBlobsContainers(blobs);
        }
        return result;
    }

    public JsonElement serialize(SqlScript src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject element = new JsonObject();
        element.add(LOCATION, context.serialize((Object)src.toByteArray()));
        if (src.withBlobs()) {
            element.add(BLOBS, context.serialize(src.getBlobsContainers()));
        }
        return element;
    }
}

