/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.sql;

import io.ultreia.java4all.util.SingletonSupplier;
import io.ultreia.java4all.util.TimeLog;
import io.ultreia.java4all.util.sql.BlobsContainer;
import io.ultreia.java4all.util.sql.SqlScript;
import io.ultreia.java4all.util.sql.SqlScriptReader;
import io.ultreia.java4all.util.sql.SqlWork;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlScriptConsumer
implements SqlWork,
Closeable,
Consumer<Connection> {
    private static final Logger log = LogManager.getLogger(SqlScriptConsumer.class);
    private static final TimeLog TIME_LOG = new TimeLog(SqlScriptConsumer.class, 100L, 500L);
    private final SingletonSupplier<SqlScriptReader> source;
    private final Set<BlobsContainer> blobsContainers;
    private final Integer batchSize;
    private final boolean commit;
    private final List<String> statements;
    private long statementCount;

    public static SqlScriptConsumer of(String source) {
        return SqlScriptConsumer.builder(source).build();
    }

    public static SqlScriptConsumer of(byte[] source) {
        return SqlScriptConsumer.builder(source).build();
    }

    public static SqlScriptConsumer of(Path source) {
        return SqlScriptConsumer.builder(source).build();
    }

    public static SqlScriptConsumer of(URL source) {
        return SqlScriptConsumer.builder(source).build();
    }

    public static SqlScriptConsumer of(SqlScript source) {
        return SqlScriptConsumer.builder(source).build();
    }

    public static Builder builder(String source) {
        return new Builder(SqlScriptReader.builder(source));
    }

    public static Builder builder(byte[] source) {
        return new Builder(SqlScriptReader.builder(source));
    }

    public static Builder builder(Path source) {
        return new Builder(SqlScriptReader.builder(source));
    }

    public static Builder builder(URL source) {
        return new Builder(SqlScriptReader.builder(source));
    }

    public static Builder builder(SqlScript source) {
        Builder builder = SqlScriptConsumer.builder(source.getLocation());
        if (source.withBlobs()) {
            builder.blobs(source.getBlobsContainers());
        }
        return builder;
    }

    public static Builder builder(SqlScriptReader source) {
        return new Builder(SqlScriptReader.builder(source));
    }

    private SqlScriptConsumer(SingletonSupplier<SqlScriptReader> source, Integer batchSize, boolean commit, Set<BlobsContainer> blobsContainers) {
        this.source = source;
        this.batchSize = batchSize;
        this.statements = new ArrayList<String>(batchSize == null ? 1 : batchSize);
        this.commit = commit;
        this.blobsContainers = blobsContainers;
    }

    @Override
    public void close() throws IOException {
        if (this.source.withValue()) {
            this.source.get().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection) throws SQLException {
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            try (Statement statement = connection.createStatement();){
                if (this.batchSize == null) {
                    this.executeOneByOne(statement);
                } else {
                    this.executeByBatch(statement);
                }
            }
            if (!this.blobsContainers.isEmpty()) {
                this.importBlobs(connection);
            }
            if (this.commit) {
                connection.commit();
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void accept(Connection connection) {
        try {
            this.execute(connection);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public long getStatementCount() {
        return this.statementCount;
    }

    private void importBlobs(Connection connection) throws SQLException {
        for (BlobsContainer blobsContainer : this.blobsContainers) {
            String tableName = blobsContainer.getTableName();
            String columnName = blobsContainer.getColumnName();
            int batchSize = 0;
            String sql = String.format("UPDATE %s SET %s = ? WHERE topiaId= ?", tableName, columnName);
            log.debug(sql);
            PreparedStatement statement = connection.prepareStatement(sql);
            try {
                for (Map.Entry<String, byte[]> containerEntry : blobsContainer.getBlobsById().entrySet()) {
                    String topiaId = containerEntry.getKey();
                    byte[] content = containerEntry.getValue();
                    statement.clearParameters();
                    statement.setBlob(1, new SerialBlob(content));
                    statement.setString(2, topiaId);
                    statement.addBatch();
                    ++this.statementCount;
                    if (this.batchSize != null && ++batchSize % this.batchSize != 0) continue;
                    this.flush(statement);
                }
                this.flush(statement);
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }

    private void executeByBatch(Statement statement) throws SQLException {
        for (String sqlStatement : this.source.get()) {
            ++this.statementCount;
            try {
                statement.addBatch(sqlStatement);
                this.statements.add(sqlStatement);
            }
            catch (Exception e) {
                log.error(String.format("Can't add sql statement (%d) in batch: %s", this.statementCount, sqlStatement), (Throwable)e);
                throw e;
            }
            if (this.statementCount <= 0L || this.statementCount % (long)this.batchSize.intValue() != 0L) continue;
            this.flush(statement);
        }
        this.flush(statement);
    }

    private void executeOneByOne(Statement statement) throws SQLException {
        for (String sqlStatement : this.source.get()) {
            long t0 = TimeLog.getTime();
            ++this.statementCount;
            try {
                statement.execute(sqlStatement);
            }
            catch (Exception e) {
                try {
                    log.error(String.format("Can't execute sql statement (%d): %s", this.statementCount, sqlStatement), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    TIME_LOG.log(t0, "executeOneByOne", String.format("statementCount: %d (%s)", this.statementCount, sqlStatement));
                    throw throwable;
                }
            }
            TIME_LOG.log(t0, "executeOneByOne", String.format("statementCount: %d (%s)", this.statementCount, sqlStatement));
        }
    }

    private void flush(Statement statement) throws SQLException {
        long t0 = TimeLog.getTime();
        try {
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                log.error(String.format("Can't execute sql statements (%d): %s", this.statementCount, this.statements), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                TIME_LOG.log(t0, "flush", String.format("statementCount: %d (batchSize: %d)", this.statementCount, this.batchSize));
                this.statements.clear();
                statement.clearBatch();
                throw throwable;
            }
        }
        TIME_LOG.log(t0, "flush", String.format("statementCount: %d (batchSize: %d)", this.statementCount, this.batchSize));
        this.statements.clear();
        statement.clearBatch();
    }

    public static class Builder {
        private final SqlScriptReader.Builder source;
        private final Set<BlobsContainer> blobsContainers;
        private Integer batchSize;
        private boolean commit;

        public Builder(SqlScriptReader.Builder source) {
            this.source = Objects.requireNonNull(source);
            this.blobsContainers = new LinkedHashSet<BlobsContainer>();
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder keepCommentLine() {
            this.source.keepCommentLine();
            return this;
        }

        public Builder commit() {
            this.commit = true;
            return this;
        }

        public Builder keepEmptyLine() {
            this.source.keepEmptyLine();
            return this;
        }

        public Builder encoding(Charset encoding) {
            this.source.encoding(Objects.requireNonNull(encoding));
            return this;
        }

        public Builder blob(BlobsContainer blobsContainers) {
            this.blobsContainers.add(Objects.requireNonNull(blobsContainers));
            return this;
        }

        public Builder blobs(Collection<BlobsContainer> blobsContainers) {
            this.blobsContainers.addAll(Objects.requireNonNull(blobsContainers));
            return this;
        }

        public SqlScriptConsumer build() {
            return new SqlScriptConsumer(SingletonSupplier.of(this.source::build), this.batchSize, this.commit, Collections.unmodifiableSet(this.blobsContainers));
        }
    }
}

