/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.sql;

import io.ultreia.java4all.util.sql.SqlFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class SqlQuery<O> {
    public abstract PreparedStatement prepareQuery(Connection var1) throws SQLException;

    public abstract O prepareResult(ResultSet var1) throws SQLException;

    public void afterExecuteQuery(ResultSet set) throws SQLException {
    }

    protected String[] getColumnNames(ResultSet set) throws SQLException {
        ResultSetMetaData metaData = set.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] result = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            result[i] = metaData.getColumnName(i + 1);
        }
        return result;
    }

    protected long getNbRows(ResultSet set) throws SQLException {
        long nbRows = 0L;
        while (set.next()) {
            ++nbRows;
        }
        set.beforeFirst();
        return nbRows;
    }

    protected Map<String, Object> getRowAsMap(String[] columnNames, ResultSet set) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            String name = columnNames[i];
            Object value = set.getObject(i + 1);
            result.put(name, value);
        }
        return result;
    }

    public static <T> SqlQuery<T> wrap(final SqlFunction<Connection, PreparedStatement> preparer, final SqlFunction<ResultSet, T> transformer) {
        return new SqlQuery<T>(){

            @Override
            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return (PreparedStatement)preparer.apply(connection);
            }

            @Override
            public T prepareResult(ResultSet set) throws SQLException {
                return transformer.apply(set);
            }
        };
    }

    public static <T> SqlQuery<T> wrap(final String sqlQuery, final SqlFunction<ResultSet, T> transformer) {
        return new SqlQuery<T>(){

            @Override
            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                return connection.prepareStatement(sqlQuery);
            }

            @Override
            public T prepareResult(ResultSet set) throws SQLException {
                return transformer.apply(set);
            }

            @Override
            public Optional<String> getSqlQuery() {
                return Optional.of(sqlQuery);
            }
        };
    }

    public Optional<String> getSqlQuery() {
        return Optional.empty();
    }

    public Optional<List<?>> getSqlArgs() {
        return Optional.empty();
    }
}

