/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import io.ultreia.java4all.util.TwoSide;
import java.util.Objects;
import java.util.function.Function;

public interface TwoSideContext<S extends TwoSide, O> {
    public static <S extends TwoSide, O> TwoSideContext<S, O> of(O left, O right) {
        return new TowSideContextImpl(left, right);
    }

    public O left();

    public O right();

    default public O onSameSide(S side) {
        return side.get(this.left(), this.right());
    }

    default public O onOppositeSide(S side) {
        return side.get(this.right(), this.left());
    }

    default public <V> TwoSideContext<S, V> then(Function<O, V> function) {
        return TwoSideContext.of(function.apply(this.left()), function.apply(this.right()));
    }

    default public TwoSideContext<S, O> flip() {
        return TwoSideContext.of(this.right(), this.left());
    }

    public static class TowSideContextImpl<S extends TwoSide, O>
    implements TwoSideContext<S, O> {
        private final O left;
        private final O right;

        public TowSideContextImpl(O left, O right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public O left() {
            return this.left;
        }

        @Override
        public O right() {
            return this.right;
        }
    }
}

