package io.ultreia.java4all.util;

/*-
 * #%L
 * Java Util extends by Ultreia.io
 * %%
 * Copyright (C) 2018 - 2024 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Objects;
import java.util.function.Function;

/**
 * Created at 19/03/2024.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 1.1.13
 */
public interface TwoSideContext<S extends TwoSide, O> {

    static <S extends TwoSide, O> TwoSideContext<S, O> of(O left, O right) {
        return new TowSideContextImpl<>(left, right);
    }

    O left();

    O right();

    default O onSameSide(S side) {
        return side.get(left(), right());
    }

    default O onOppositeSide(S side) {
        return side.get(right(), left());
    }

    default <V> TwoSideContext<S, V> then(Function<O, V> function) {
        return of(function.apply(left()), function.apply(right()));
    }

    default TwoSideContext<S, O> flip() {
        return of(right(), left());
    }

    class TowSideContextImpl<S extends TwoSide, O> implements TwoSideContext<S, O> {

        private final O left;
        private final O right;

        public TowSideContextImpl(O left, O right) {
            this.left = Objects.requireNonNull(left);
            this.right = Objects.requireNonNull(right);
        }

        @Override
        public O left() {
            return left;
        }

        @Override
        public O right() {
            return right;
        }
    }
}
