/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters;

import com.google.auto.service.AutoService;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.ultreia.java4all.util.json.JsonAdapter;
import java.io.IOException;

@AutoService(value={JsonAdapter.class})
public class IntegerAdapter
extends TypeAdapter<Integer>
implements JsonAdapter {
    @Override
    public Class<?> type() {
        return Integer.class;
    }

    public void write(JsonWriter out, Integer value) throws IOException {
        out.value((Number)value);
    }

    public Integer read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            String result = in.nextString();
            if ("".equals(result)) {
                return null;
            }
            return Integer.valueOf(result);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

