/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters;

import com.google.auto.service.AutoService;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.JsonAdapter;
import io.ultreia.java4all.util.sql.BlobsContainer;
import java.lang.reflect.Type;
import java.util.HashMap;

@AutoService(value={JsonAdapter.class})
public class BlobsContainerAdapter
implements JsonDeserializer<BlobsContainer>,
JsonSerializer<BlobsContainer>,
JsonAdapter {
    public static final String TABLE_NAME = "tableName";
    public static final String COLUMN_NAME = "columnName";
    public static final String BLOBS_BY_ID = "blobsById";
    private static final Type TYPE = TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{String.class, byte[].class}).getType();

    @Override
    public Class<?> type() {
        return BlobsContainer.class;
    }

    public BlobsContainer deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String tableName = jsonObject.get(TABLE_NAME).getAsString();
        String columnName = jsonObject.get(COLUMN_NAME).getAsString();
        HashMap blobsById = (HashMap)context.deserialize(jsonObject.get(BLOBS_BY_ID), TYPE);
        return new BlobsContainer(tableName, columnName, blobsById);
    }

    public JsonElement serialize(BlobsContainer src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject element = new JsonObject();
        element.add(TABLE_NAME, context.serialize((Object)src.getTableName()));
        element.add(COLUMN_NAME, context.serialize((Object)src.getColumnName()));
        element.add(BLOBS_BY_ID, context.serialize(src.getBlobsById()));
        return element;
    }
}

