/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonHelper {
    public static String readStringOrNull(String name, JsonObject object) {
        JsonPrimitive element = object.getAsJsonPrimitive(name);
        return element != null ? element.getAsString() : null;
    }

    public static String readString(String name, JsonObject object) {
        JsonPrimitive element = object.getAsJsonPrimitive(name);
        return element != null ? element.getAsString() : "";
    }

    public static List<String> readStringList(JsonDeserializationContext context, String name, JsonObject object) {
        JsonElement element = object.get(name);
        return element == null ? null : List.of((String[])context.deserialize(element, String[].class));
    }

    public static Set<String> readStringSetOrEmpty(JsonDeserializationContext context, String name, JsonObject object) {
        JsonElement element = object.get(name);
        return element == null ? Set.of() : new LinkedHashSet<String>(List.of((String[])context.deserialize(element, String[].class)));
    }

    public static boolean readBoolean(String name, JsonObject object) {
        JsonPrimitive element = object.getAsJsonPrimitive(name);
        return element != null && element.getAsBoolean();
    }

    public static <O> O readObject(JsonDeserializationContext context, String name, Class<O> type, JsonObject object) {
        JsonElement element = object.get(name);
        return (O)(element == null ? null : context.deserialize(element, type));
    }

    public static <O> List<O> readObjectListOrEmpty(JsonDeserializationContext context, String name, Class<O> type, JsonObject object) {
        JsonElement element = object.get(name);
        return element == null ? List.of() : (List)context.deserialize(element, TypeToken.getParameterized(List.class, (Type[])new Type[]{type}).getType());
    }

    public static <O> List<O> readObjectList(JsonDeserializationContext context, String name, Class<O> type, JsonObject object) {
        JsonElement element = object.get(name);
        return element == null ? null : (List)context.deserialize(element, TypeToken.getParameterized(List.class, (Type[])new Type[]{type}).getType());
    }

    public static <K, V> Map<K, V> readObjectMapOrEmpty(JsonDeserializationContext context, String name, Class<K> keyType, Class<V> valueType, JsonObject object) {
        JsonElement element = object.get(name);
        return element == null ? Map.of() : (Map)context.deserialize(element, TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyType, valueType}).getType());
    }

    public static <K, V> Map<K, V> readObjectMap(JsonDeserializationContext context, String name, Class<K> keyType, Class<V> valueType, JsonObject object) {
        JsonElement element = object.get(name);
        return element == null ? null : (Map)context.deserialize(element, TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyType, valueType}).getType());
    }

    public static void addToResult(JsonSerializationContext context, JsonObject result, String name, Object table) {
        if (table == null) {
            return;
        }
        if (table instanceof Boolean && !((Boolean)table).booleanValue()) {
            return;
        }
        if (table instanceof String && ((String)table).isEmpty()) {
            return;
        }
        if (table instanceof Collection && ((Collection)table).isEmpty()) {
            return;
        }
        if (table instanceof Map && ((Map)table).isEmpty()) {
            return;
        }
        result.add(name, context.serialize(table));
    }

    public static void addToProperties(List<Object> properties, Object table) {
        if (table == null) {
            return;
        }
        if (table instanceof Boolean && !((Boolean)table).booleanValue()) {
            properties.add(null);
            return;
        }
        if (table instanceof String && ((String)table).isEmpty()) {
            properties.add(null);
            return;
        }
        if (table instanceof Collection && ((Collection)table).isEmpty()) {
            properties.add(null);
            return;
        }
        if (table instanceof Map && ((Map)table).isEmpty()) {
            properties.add(null);
            return;
        }
        properties.add(table.toString());
    }

    public static String codeProperties(List<Object> properties) {
        return properties.stream().map(o -> o == null ? "" : o.toString()).collect(Collectors.joining("~"));
    }
}

