/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import io.ultreia.java4all.util.TwoSide;
import java.util.function.Function;

public interface TwoSideContext<S extends TwoSide, O> {
    public O left();

    public O right();

    default public O onSameSide(S side) {
        return side.get(this.left(), this.right());
    }

    default public O onOppositeSide(S side) {
        return side.get(this.right(), this.left());
    }

    default public <V> TwoSideContext<S, V> then(final Function<O, V> function) {
        return new TwoSideContext<S, V>(){

            @Override
            public V left() {
                return function.apply(TwoSideContext.this.right());
            }

            @Override
            public V right() {
                return function.apply(TwoSideContext.this.left());
            }
        };
    }

    default public TwoSideContext<S, O> flip() {
        return new TwoSideContext<S, O>(){

            @Override
            public O left() {
                return TwoSideContext.this.right();
            }

            @Override
            public O right() {
                return TwoSideContext.this.left();
            }
        };
    }
}

