/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.sql;

import io.ultreia.java4all.util.json.JsonAware;
import io.ultreia.java4all.util.sql.BlobsContainer;
import io.ultreia.java4all.util.sql.SqlScriptReader;
import io.ultreia.java4all.util.sql.SqlScriptWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;

public class SqlScript
implements JsonAware {
    protected Supplier<SqlScriptReader> location;
    protected Set<BlobsContainer> blobsContainers;

    public static SqlScript of(Path location) {
        try {
            return SqlScript.of(location.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static SqlScript of(URI location) {
        try {
            return SqlScript.of(location.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static SqlScript of(byte ... location) {
        return new SqlScript(() -> SqlScriptReader.of(location));
    }

    public static SqlScript of(String location) {
        return new SqlScript(() -> SqlScriptReader.of(location));
    }

    public static SqlScript of(URL location) {
        return new SqlScript(() -> SqlScriptReader.of(location));
    }

    protected SqlScript(Supplier<SqlScriptReader> location) {
        this.location = location;
    }

    public SqlScript addBlobsContainer(BlobsContainer blobsContainer) {
        this.getBlobsContainers().add(blobsContainer);
        return this;
    }

    public SqlScript addBlobsContainers(Collection<BlobsContainer> blobsContainers) {
        this.getBlobsContainers().addAll(blobsContainers);
        return this;
    }

    public Set<BlobsContainer> getBlobsContainers() {
        return this.blobsContainers == null ? (this.blobsContainers = new LinkedHashSet<BlobsContainer>()) : this.blobsContainers;
    }

    public SqlScriptReader getLocation() {
        return this.location.get();
    }

    public void setLocation(Supplier<SqlScriptReader> location) {
        this.location = location;
    }

    public void copy(Path target) throws IOException {
        try (SqlScriptWriter scriptWriter = SqlScriptWriter.of(target);){
            this.copy(scriptWriter);
        }
    }

    public void copy(OutputStream target) throws IOException {
        try (SqlScriptWriter scriptWriter = SqlScriptWriter.of(target);){
            this.copy(scriptWriter);
        }
    }

    public void copyAndCompress(Path target) throws IOException {
        try (SqlScriptWriter scriptWriter = SqlScriptWriter.builder(target).gzip().build();){
            this.copy(scriptWriter);
        }
    }

    public void copy(SqlScriptWriter scriptWriter) throws IOException {
        try (SqlScriptReader scriptReader = this.location.get();){
            for (String statement : scriptReader) {
                scriptWriter.writeSql(statement);
            }
        }
    }

    public String content() {
        String string;
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        try {
            try (BufferedOutputStream buffer = new BufferedOutputStream(target);){
                this.copy(buffer);
            }
            string = target.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    target.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't copy script content", e);
            }
        }
        target.close();
        return string;
    }

    public byte[] toByteArray() {
        byte[] byArray;
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        try {
            try (BufferedOutputStream buffer = new BufferedOutputStream(target);){
                this.copy(buffer);
            }
            byArray = target.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    target.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't copy script content", e);
            }
        }
        target.close();
        return byArray;
    }

    public boolean withBlobs() {
        return this.blobsContainers != null && this.blobsContainers.size() > 1;
    }
}

