/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.io;

import io.ultreia.java4all.util.SingletonSupplier;
import io.ultreia.java4all.util.io.ReaderContract;
import io.ultreia.java4all.util.io.WriterContract;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public interface StorageContract<O>
extends ReaderContract<O>,
WriterContract<O> {
    public static <O> O get(Map<String, O> cache, String format) {
        O storage = cache.get(Objects.requireNonNull(format));
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Can't find storage for format: %s, available formats: %s", format, cache.keySet()));
        }
        return storage;
    }

    public static <O, C extends StorageContract<O>> SingletonSupplier<Map<String, C>> load(Class<C> type) {
        return StorageContract.load(type.getClassLoader(), type);
    }

    public static <O, C extends StorageContract<O>> SingletonSupplier<Map<String, C>> load(ClassLoader classLoader, Class<C> type) {
        return SingletonSupplier.of(() -> {
            LinkedHashMap<String, StorageContract> result = new LinkedHashMap<String, StorageContract>();
            for (StorageContract o : ServiceLoader.load(type, classLoader)) {
                String format = o.getFormat();
                StorageContract previous = result.put(format, o);
                if (previous == null) continue;
                throw new IllegalStateException(String.format("Not unique storage for format %s (type: %s)", format, type.getName()));
            }
            return Collections.unmodifiableMap(result);
        });
    }
}

