/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.io;

import io.ultreia.java4all.util.io.ConfigFormat;
import io.ultreia.java4all.util.io.ReaderException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public interface ReaderContract<O>
extends ConfigFormat {
    default public O read(Path path) throws ReaderException {
        try {
            return this.read(path.toUri().toURL(), StandardCharsets.UTF_8);
        }
        catch (MalformedURLException e) {
            throw new ReaderException(String.format("[%s] Can't read file: %s", this.getFormat(), path), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public O read(URL url, Charset encoding) throws ReaderException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), encoding));){
            O o = this.read(reader, url.toString().substring(url.toString().lastIndexOf("/") + 1));
            return o;
        }
        catch (Exception e) {
            throw new ReaderException(String.format("[%s] Can't read file: %s", this.getFormat(), url), e);
        }
    }

    public O read(Reader var1, String var2) throws Exception;
}

