/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.sql;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BlobsContainer {
    private final String tableName;
    private final String columnName;
    private final HashMap<String, byte[]> blobsById;

    public static Builder builder(String tableName, String columnName) {
        return new Builder(tableName, columnName);
    }

    public BlobsContainer(String tableName, String columnName, HashMap<String, byte[]> blobsById) {
        this.tableName = Objects.requireNonNull(tableName);
        this.columnName = Objects.requireNonNull(columnName);
        this.blobsById = Objects.requireNonNull(blobsById);
    }

    public BlobsContainer add(Map<String, byte[]> blobsById) {
        HashMap<String, byte[]> newMap = new HashMap<String, byte[]>(this.blobsById.size() + blobsById.size());
        newMap.putAll(this.blobsById);
        newMap.putAll(blobsById);
        return new BlobsContainer(this.tableName, this.columnName, newMap);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public HashMap<String, byte[]> getBlobsById() {
        return this.blobsById;
    }

    public boolean isEmpty() {
        return this.blobsById.isEmpty();
    }

    public static class Builder {
        private final String tableName;
        private final String columnName;
        private final HashMap<String, byte[]> blobsContainer = new HashMap();

        private Builder(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }

        public Builder addBlob(String id, byte[] content) {
            this.blobsContainer.put(id, content);
            return this;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public BlobsContainer build() {
            return new BlobsContainer(this.tableName, this.columnName, this.blobsContainer);
        }
    }
}

