/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters.guava;

import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class MultimapAdapterSupport<K, V, M extends Multimap<K, V>>
implements JsonDeserializer<M>,
JsonSerializer<M> {
    static <K, V> TypeToken<Map<K, Collection<V>>> multimapOf(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Map<K, Collection<V>>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    protected abstract M createMultimap();

    public M deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type keyType = actualTypeArguments[0];
        Type valueType = actualTypeArguments[1];
        Type type2 = MultimapAdapterSupport.multimapOf(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType)).getType();
        M result = this.createMultimap();
        if (!json.isJsonArray()) {
            Map map = (Map)context.deserialize(json, type2);
            for (Object key : map.keySet()) {
                List multimapValues = (List)map.get(key);
                result.putAll(key, (Iterable)multimapValues);
            }
        } else {
            JsonArray asJsonArray = json.getAsJsonArray();
            for (JsonElement jsonElement : asJsonArray) {
                JsonObject entryObject = (JsonObject)jsonElement;
                Object key = context.deserialize(entryObject.get("key"), keyType);
                JsonArray valuesArray = (JsonArray)entryObject.get("value");
                Iterator valuesIterator = valuesArray.iterator();
                LinkedList<Object> entryValues = new LinkedList<Object>();
                while (valuesIterator.hasNext()) {
                    JsonElement value = (JsonElement)valuesIterator.next();
                    entryValues.add(context.deserialize(value, valueType));
                }
                result.putAll(key, entryValues);
            }
        }
        return result;
    }

    public JsonElement serialize(M src, Type type, JsonSerializationContext context) {
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type valueType = actualTypeArguments[1];
        JsonArray result = new JsonArray();
        for (Map.Entry entry : src.asMap().entrySet()) {
            Object key = entry.getKey();
            Collection value = (Collection)entry.getValue();
            JsonObject entryObject = new JsonObject();
            entryObject.add("key", context.serialize(key));
            JsonArray valuesObject = new JsonArray();
            for (Object o1 : value) {
                valuesObject.add(context.serialize(o1, valueType));
            }
            entryObject.add("value", (JsonElement)valuesObject);
            result.add((JsonElement)entryObject);
        }
        return result;
    }
}

