/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters.guava;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.ultreia.java4all.util.json.JsonAdapter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;

@AutoService(value={JsonAdapter.class})
public class ImmutableSetAdapter<V>
implements JsonDeserializer<ImmutableSet<V>>,
JsonAdapter {
    public static Type setOf(Type subType) {
        return TypeToken.getParameterized(Set.class, (Type[])new Type[]{subType}).getType();
    }

    @Override
    public Class<?> type() {
        return ImmutableSet.class;
    }

    public ImmutableSet<V> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type actualTypeArgument = actualTypeArguments[0];
        Type type2 = ImmutableSetAdapter.setOf(actualTypeArgument);
        Set set = (Set)context.deserialize(json, type2);
        return ImmutableSet.copyOf((Collection)set);
    }
}

