/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters.guava;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ultreia.java4all.util.json.JsonAdapter;
import io.ultreia.java4all.util.json.adapters.guava.MultimapAdapterSupport;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

@AutoService(value={JsonAdapter.class})
public class ImmutableMultimapAdapter<K, V>
implements JsonSerializer<ImmutableMultimap<K, V>>,
JsonDeserializer<ImmutableMultimap<K, V>>,
JsonAdapter {
    @Override
    public Class<?> type() {
        return ImmutableMultimap.class;
    }

    public JsonElement serialize(ImmutableMultimap<K, V> src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src.asMap());
    }

    public ImmutableMultimap<K, V> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type keyType = actualTypeArguments[0];
        Type valueType = actualTypeArguments[1];
        Type type2 = MultimapAdapterSupport.multimapOf(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType)).getType();
        Map map = (Map)context.deserialize(json, type2);
        for (Object key : map.keySet()) {
            List multimapValues = (List)map.get(key);
            for (Object multimapValue : multimapValues) {
                builder.put(key, multimapValue);
            }
        }
        return builder.build();
    }
}

