/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util.json.adapters.guava;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.ultreia.java4all.util.json.JsonAdapter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

@AutoService(value={JsonAdapter.class})
public class ImmutableMapAdapter<K, V>
implements JsonDeserializer<ImmutableMap<K, V>>,
JsonAdapter {
    public static <K, V> TypeToken<Map<K, V>> mapOf(TypeToken<K> keyType, TypeToken<V> valueType) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    @Override
    public Class<?> type() {
        return ImmutableMap.class;
    }

    public ImmutableMap<K, V> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        Type keyType = actualTypeArguments[0];
        Type valueType = actualTypeArguments[1];
        Type type2 = ImmutableMapAdapter.mapOf(TypeToken.of((Type)keyType), TypeToken.of((Type)valueType)).getType();
        Map map = (Map)context.deserialize(json, type2);
        return ImmutableMap.copyOf((Map)map);
    }
}

