/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;

public class ServiceLoaders {
    public static <S> S loadUniqueService(Class<S> serviceType) {
        Iterator<S> iterator = ServiceLoader.load(serviceType).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No instance found for " + serviceType.getName());
        }
        S result = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("Found more than one instance for " + serviceType.getName());
        }
        return result;
    }

    public static <O> List<Class<O>> loadTypes(Class<O> serviceType) {
        try {
            Enumeration<URL> resources = ServiceLoaders.class.getClassLoader().getResources("META-INF/services/" + serviceType.getName());
            LinkedList<Class<O>> result = new LinkedList<Class<O>>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        try {
                            Class<?> aClass = Class.forName(line);
                            result.add(aClass);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Can't get class: " + line);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (bufferedReader == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    bufferedReader.close();
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't get loaders", e);
        }
    }
}

