/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class Predicates {
    public static <O> Predicate<O> predicate(Collection<Predicate<O>> predicates) {
        Iterator<Predicate<O>> iterator = Objects.requireNonNull(predicates).iterator();
        if (!iterator.hasNext()) {
            return d -> true;
        }
        Predicate<O> result = iterator.next();
        while (iterator.hasNext()) {
            result = result.and(iterator.next());
        }
        return result;
    }

    public static <O> Predicate<O> Equals(O value) {
        return new EqualsPredicate<O>(value);
    }

    public static <O> Predicate<O> NotEquals(O value) {
        return Predicates.Equals(value).negate();
    }

    public static <O> Predicate<O> In(Collection<O> value) {
        return new InPredicate<O>(value);
    }

    public static <O> Predicate<O> NotIn(Collection<O> value) {
        return Predicates.In(value).negate();
    }

    public static Predicate<String> StringContains(String value) {
        return new StringContainsPredicate(value);
    }

    public static Predicate<String> NotStringContains(String value) {
        return Predicates.StringContains(value).negate();
    }

    public static Predicate<String> StringMatches(String value) {
        return new StringMatchesPredicate(value);
    }

    public static Predicate<String> NotStringMatches(String value) {
        return Predicates.StringMatches(value).negate();
    }

    public static <O extends Comparable<O>> Predicate<O> After(O min) {
        return new AfterPredicate<O>(min, false);
    }

    public static <O extends Comparable<O>> Predicate<O> AfterOrEquals(O min) {
        return new AfterPredicate<O>(min, true);
    }

    public static <O extends Comparable<O>> Predicate<O> Before(O max) {
        return new BeforePredicate<O>(max, false);
    }

    public static <O extends Comparable<O>> Predicate<O> BeforeOrEquals(O max) {
        return new BeforePredicate<O>(max, true);
    }

    public static <O extends Comparable<O>> Predicate<O> Between(O min, O max) {
        return new AfterPredicate<O>(min, false).and(new BeforePredicate<O>(max, false));
    }

    public static <O extends Comparable<O>> Predicate<O> BetweenOrEquals(O min, O max) {
        return new AfterPredicate<O>(min, true).and(new BeforePredicate<O>(max, true));
    }

    public static final class StringMatchesPredicate
    implements Predicate<String> {
        private final String value;

        public StringMatchesPredicate(String value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean test(String o) {
            return o.matches(this.value);
        }
    }

    public static final class StringContainsPredicate
    implements Predicate<String> {
        private final String value;

        public StringContainsPredicate(String value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean test(String o) {
            return o.contains(this.value);
        }
    }

    public static final class AfterPredicate<O extends Comparable<O>>
    implements Predicate<O> {
        private final O value;
        private final boolean orEquals;

        public AfterPredicate(O value, boolean orEquals) {
            this.value = (Comparable)Objects.requireNonNull(value);
            this.orEquals = orEquals;
        }

        @Override
        public boolean test(O o) {
            int i = o.compareTo(this.value);
            return i > 0 || i == 0 && this.orEquals;
        }
    }

    public static final class BeforePredicate<O extends Comparable<O>>
    implements Predicate<O> {
        private final O value;
        private final boolean orEquals;

        public BeforePredicate(O value, boolean orEquals) {
            this.value = (Comparable)Objects.requireNonNull(value);
            this.orEquals = orEquals;
        }

        @Override
        public boolean test(O o) {
            int i = o.compareTo(this.value);
            return i < 0 || i == 0 && this.orEquals;
        }
    }

    public static final class InPredicate<O>
    implements Predicate<O> {
        private final Collection<O> value;

        public InPredicate(Collection<O> value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean test(O o) {
            return this.value.contains(o);
        }
    }

    public static final class EqualsPredicate<O>
    implements Predicate<O> {
        private final O value;

        public EqualsPredicate(O value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean test(O o) {
            return Objects.equals(o, this.value);
        }
    }
}

