/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Zips {
    private static final int BUFFER_SIZE = 8192;

    public static void uncompress(InputStream stream, File targetDir) throws IOException {
        Zips.uncompressAndRename(stream, targetDir, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void uncompressAndRename(InputStream stream, File targetDir, String renameFrom, String renameTo) throws IOException {
        try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(stream));){
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                BufferedOutputStream out;
                block25: {
                    String name = entry.getName();
                    if (renameFrom != null && renameTo != null) {
                        name = name.replaceAll(renameFrom, renameTo);
                    }
                    File target = new File(targetDir, name);
                    if (entry.isDirectory()) {
                        Zips.createDirectoryIfNecessary(target);
                        continue;
                    }
                    Zips.createDirectoryIfNecessary(target.getParentFile());
                    out = new BufferedOutputStream(new FileOutputStream(target));
                    Throwable throwable = null;
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = in.read(buffer, 0, 8192)) != -1) {
                            ((OutputStream)out).write(buffer, 0, len);
                        }
                        if (out == null) continue;
                        if (throwable == null) break block25;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (out == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ((OutputStream)out).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ((OutputStream)out).close();
                            throw throwable3;
                        }
                    }
                    try {
                        ((OutputStream)out).close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ((OutputStream)out).close();
            }
            return;
        }
    }

    public static void uncompressFiltred(File file, File targetDir, String ... excludes) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            boolean excludeEntry = false;
            if (excludes != null) {
                for (String exclude : excludes) {
                    if (!name.matches(exclude)) continue;
                    excludeEntry = true;
                }
            }
            if (excludeEntry) continue;
            File target = new File(targetDir, name);
            if (entry.isDirectory()) {
                Zips.createDirectoryIfNecessary(target);
                continue;
            }
            Zips.createDirectoryIfNecessary(target.getParentFile());
            InputStream in = zipFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
                Throwable throwable2 = null;
                try {
                    int len;
                    byte[] buffer = new byte[8192];
                    while ((len = in.read(buffer, 0, 8192)) != -1) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (out == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    public static void createDirectoryIfNecessary(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static boolean isZipFile(File file) {
        boolean result = false;
        try {
            ZipFile zipFile = new ZipFile(file);
            zipFile.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

