/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class Objects2 {
    static final Predicate<PropertyDescriptor> IS_READ_DESCRIPTOR = input -> input.getReadMethod() != null;
    static final Predicate<PropertyDescriptor> IS_WRITE_DESCRIPTOR = input -> input.getWriteMethod() != null;

    private Objects2() {
    }

    public static <O> Class<O> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Can't get class: %s", className), e);
        }
    }

    public static <O> O newInstance(Class<O> type) {
        Objects.requireNonNull(type);
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Can't instantiate type: %s", type.getName()), e);
        }
    }

    public static void walk(ClassWalkVisitor visitor, Class<?> beanType) {
        new ClassWalker(visitor).visit(beanType);
    }

    static class ClassWalker {
        private final ClassWalkVisitor visitor;
        private final Set<Class<?>> exploredTypes;

        ClassWalker(ClassWalkVisitor visitor) {
            this.visitor = visitor;
            this.exploredTypes = new LinkedHashSet();
        }

        public void visit(Class<?> beanType) {
            this.exploredTypes.clear();
            this.accept(beanType);
        }

        protected boolean accept(Class<?> beanType) {
            boolean canContinue;
            if (this.exploredTypes.contains(beanType)) {
                return this.visitor.canContinue();
            }
            this.exploredTypes.add(beanType);
            this.visitor.onVisit(beanType);
            if (!this.visitor.canContinue()) {
                return false;
            }
            if (beanType.getSuperclass() != null && !(canContinue = this.accept(beanType.getSuperclass()))) {
                return false;
            }
            for (Class<?> anInterface : beanType.getInterfaces()) {
                boolean canContinue2 = this.accept(anInterface);
                if (canContinue2) continue;
                return false;
            }
            return this.visitor.canContinue();
        }
    }

    static interface ClassWalkVisitor {
        public void onVisit(Class<?> var1);

        public boolean canContinue();
    }
}

