package io.ultreia.java4all.lang;

/*-
 * #%L
 * Java Lang extends by Ultreia.io
 * %%
 * Copyright (C) 2017 - 2021 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * Created on 12/11/2021.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.0.3
 */
public interface TwoSideContext<S extends TwoSide, O> {

    O left();

    O right();

    default O onSameSide(S side) {
        return side.get(left(), right());
    }

    default O onOppositeSide(S side) {
        return side.get(right(), left());
    }

    default TwoSideContext<S, O> flip() {
        return new TwoSideContext<>() {
            @Override
            public O left() {
                return TwoSideContext.this.right();
            }

            @Override
            public O right() {
                return TwoSideContext.this.left();
            }
        };
    }
}
