/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassLoaders {
    public static List<URL> getURLs(String pattern) {
        return ClassLoaders.getURLs(pattern, (URLClassLoader)null);
    }

    public static List<URL> getURLs(String pattern, URLClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        URL[] arrayURL = ClassLoaders.getURLs(classLoader);
        return ClassLoaders.getURLs(pattern, arrayURL);
    }

    public static URL[] getURLs(URLClassLoader classLoader) {
        URL[] result;
        Method m;
        if (classLoader == null) {
            classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        try {
            m = classLoader.getClass().getMethod("getAllURLs", new Class[0]);
        }
        catch (Exception e) {
            m = null;
        }
        if (m == null) {
            result = classLoader.getURLs();
        } else {
            try {
                result = (URL[])m.invoke((Object)classLoader, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    public static List<URL> getURLs(String pattern, URL ... arrayURL) {
        URL jarURL;
        long t0 = System.nanoTime();
        LinkedHashSet<URL> urlList = new LinkedHashSet<URL>();
        if (arrayURL.length == 1 && ClassLoaders.isJar((jarURL = arrayURL[0]).toString())) {
            try {
                arrayURL = ClassLoaders.getClassPathURLsFromJarManifest(jarURL);
            }
            catch (Exception e) {
                arrayURL = new URL[]{jarURL};
            }
        }
        for (URL urlFile : arrayURL) {
            File file = ClassLoaders.toFile(urlFile);
            String fileName = file.getAbsolutePath();
            if (!file.exists()) continue;
            if (ClassLoaders.isJar(fileName)) {
                urlList.addAll(ClassLoaders.getURLsFromJar(file, pattern));
                continue;
            }
            if (file.isDirectory()) {
                urlList.addAll(ClassLoaders.getURLsFromDirectory(file, pattern));
                continue;
            }
            if (!ClassLoaders.isZip(fileName)) continue;
            urlList.addAll(ClassLoaders.getURLsFromZip(file, pattern));
        }
        return new LinkedList<URL>(urlList);
    }

    public static List<URL> getURLsFromZip(File zipFile, String pattern) {
        try {
            LinkedHashSet<URL> result = new LinkedHashSet<URL>();
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
                while (zis.available() != 0) {
                    ZipEntry entry = zis.getNextEntry();
                    if (entry == null) {
                        break;
                    }
                    String name = entry.getName();
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = ClassLoaders.getURL(name);
                    result.add(url);
                }
            }
            return new LinkedList<URL>(result);
        }
        catch (IOException eee) {
            throw new RuntimeException("Can't get url from zip: " + zipFile.getAbsolutePath(), eee);
        }
    }

    public static URL getURL(String name) {
        URL url = ClassLoaders.getURLOrNull(name);
        if (url != null) {
            return url;
        }
        throw new RuntimeException(String.format("Can't find resource: %s", name));
    }

    public static URL getURLOrNull(String name) {
        URL url;
        File file = new File(name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (name.length() > 1 && name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((url = ClassLoader.getSystemClassLoader().getResource(name)) != null) {
            return url;
        }
        ClassLoader cl = ClassLoaders.class.getClassLoader();
        url = cl.getResource(name);
        return url;
    }

    public static boolean isJar(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".jar".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static boolean isZip(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".zip".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static List<URL> getURLsFromJar(File jarfile, String pattern) {
        try {
            LinkedHashSet<URL> result = new LinkedHashSet<URL>();
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(jarfile));){
                while (zis.available() != 0) {
                    ZipEntry entry = zis.getNextEntry();
                    if (entry == null) {
                        break;
                    }
                    String name = entry.getName();
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = ClassLoaders.getURL(name);
                    result.add(url);
                }
            }
            return new LinkedList<URL>(result);
        }
        catch (IOException eee) {
            throw new RuntimeException(String.format("Can't get url from zip: %s", jarfile.getAbsolutePath()), eee);
        }
    }

    public static URL[] getClassPathURLsFromJarManifest(URL jarURL) throws IOException {
        URL[] result;
        File jarFile = ClassLoaders.toFile(jarURL);
        try (JarFile jar = new JarFile(jarFile);){
            File container = jarFile.getParentFile();
            Manifest mf = jar.getManifest();
            String classPath = null;
            if (mf != null && mf.getMainAttributes() != null) {
                classPath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            }
            String[] paths = classPath != null ? classPath.split(" ") : new String[]{};
            result = new URL[paths.length + 1];
            result[0] = jarURL;
            for (int i = 0; i < paths.length; ++i) {
                String s = paths[i];
                if (s.indexOf(58) != -1) {
                    result[i + 1] = new URL(s);
                    continue;
                }
                File path = s.startsWith(".") || !s.startsWith("/") ? new File(container, s) : new File(s);
                result[i + 1] = path.toURI().toURL();
            }
        }
        return result;
    }

    public static List<URL> getURLsFromDirectory(File repository, String pattern) {
        try {
            LinkedList<URL> urlList = new LinkedList<URL>();
            File[] filesList = repository.listFiles();
            if (filesList != null) {
                for (File file : filesList) {
                    String name = file.getAbsolutePath();
                    if (file.exists() && file.isDirectory()) {
                        urlList.addAll(ClassLoaders.getURLsFromDirectory(file, pattern));
                        continue;
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = file.toURI().toURL();
                    urlList.add(url);
                }
            }
            return urlList;
        }
        catch (MalformedURLException eee) {
            throw new RuntimeException(String.format("Can't convert url to file %s", repository + " (pattern " + pattern + ") "), eee);
        }
    }

    public static File toFile(URL url) {
        if (url == null || !"file".equalsIgnoreCase(url.getProtocol())) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        filename = ClassLoaders.decodeUrl(filename);
        return new File(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeUrl(String url) {
        String decoded = url;
        if (url != null && url.indexOf(37) >= 0) {
            int n = url.length();
            StringBuilder buffer = new StringBuilder();
            ByteBuffer bytes = ByteBuffer.allocate(n);
            int i = 0;
            while (i < n) {
                if (url.charAt(i) == '%') {
                    try {
                        do {
                            byte octet = (byte)Integer.parseInt(url.substring(i + 1, i + 3), 16);
                            bytes.put(octet);
                        } while ((i += 3) < n && url.charAt(i) == '%');
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    finally {
                        if (bytes.position() <= 0) continue;
                        bytes.flip();
                        buffer.append(StandardCharsets.UTF_8.decode(bytes).toString());
                        bytes.clear();
                        continue;
                    }
                }
                buffer.append(url.charAt(i++));
            }
            decoded = buffer.toString();
        }
        return decoded;
    }

    public static void addDefaultClassLoader(URL url) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoaders.addClassLoader(classLoader, url);
    }

    public static void addClassLoader(ClassLoader classLoader, URL url) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Can't add url in class loader %s: %s", classLoader, e), e);
        }
    }
}

