/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import io.ultreia.java4all.lang.Objects2;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;

public class Getters {
    public static Set<String> getReadableProperties(Class<?> beanType) {
        Objects.requireNonNull(beanType);
        final HashSet<String> result = new HashSet<String>();
        Objects2.walk(new Objects2.ClassWalkVisitor(){

            @Override
            public void onVisit(Class<?> beanType) {
                for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(beanType)) {
                    if (!Objects2.IS_READ_DESCRIPTOR.test(descriptor)) continue;
                    result.add(descriptor.getName());
                }
            }

            @Override
            public boolean canContinue() {
                return true;
            }
        }, beanType);
        result.remove("class");
        return result;
    }

    public static boolean isNestedReadableProperty(Class<?> beanType, String propertyName) {
        Objects.requireNonNull(beanType);
        Objects.requireNonNull(propertyName);
        boolean result = propertyName.contains(".");
        if (result) {
            int dotIndex = propertyName.indexOf(".");
            String firstLevelProperty = propertyName.substring(0, dotIndex);
            Class<?> nestedType = Getters.getReadableType(beanType, firstLevelProperty);
            if (nestedType == null) {
                result = false;
            } else {
                String rest = propertyName.substring(dotIndex + 1);
                result = Getters.isNestedReadableProperty(nestedType, rest);
            }
        } else {
            Class<?> nestedType = Getters.getReadableType(beanType, propertyName);
            result = nestedType != null;
        }
        return result;
    }

    public static Class<?> getReadableType(Class<?> beanType, final String propertyName) {
        Objects.requireNonNull(beanType);
        Objects.requireNonNull(propertyName);
        final LinkedList finalResult = new LinkedList();
        Objects2.walk(new Objects2.ClassWalkVisitor(){
            private Class<?> result = null;

            @Override
            public void onVisit(Class<?> beanType) {
                for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(beanType)) {
                    String name = descriptor.getName();
                    if (!Objects2.IS_READ_DESCRIPTOR.test(descriptor) || !propertyName.equals(name)) continue;
                    this.result = descriptor.getReadMethod().getReturnType();
                    finalResult.add(this.result);
                    break;
                }
            }

            @Override
            public boolean canContinue() {
                return this.result == null;
            }
        }, beanType);
        return finalResult.isEmpty() ? null : (Class)finalResult.get(0);
    }
}

