package io.ultreia.java4all.lang;

/*-
 * #%L
 * Java Lang extends by Ultreia.io
 * %%
 * Copyright (C) 2017 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

/**
 * Created by tchemit on 28/09/17.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class SingletonSupplier<O> implements Supplier<O>, Closeable {

    private final Supplier<O> supplier;
    private O cache;

    public static <O> SingletonSupplier<O> of(Supplier<O> supplier) {
        return new SingletonSupplier<>(supplier);
    }

    private SingletonSupplier(Supplier<O> supplier) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
    }

    @Override
    public O get() {
        if (cache == null) {
            cache = supplier.get();
        }
        return cache;
    }

    @Override
    public void close() {
        if (cache != null && cache instanceof Closeable) {
            try {
                ((Closeable) cache).close();
            } catch (IOException e) {
                throw new RuntimeException("Could not close " + cache, e);
            } finally {
                cache = null;
            }
        }
    }

}
