/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import io.ultreia.java4all.lang.GetterProducer;
import io.ultreia.java4all.lang.SetterProducer;
import io.ultreia.java4all.lang.TypedGetterProducer;
import io.ultreia.java4all.lang.TypedSetterProducer;
import java.beans.PropertyDescriptor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Objects2 {
    static final Predicate<PropertyDescriptor> IS_READ_DESCRIPTOR = input -> input.getReadMethod() != null;
    static final Predicate<PropertyDescriptor> IS_WRITE_DESCRIPTOR = input -> input.getWriteMethod() != null;

    public static <O> O newInstance(Class<O> type) {
        Objects.requireNonNull(type);
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(String.format("Can't instantiate type: %s", type.getName()), e);
        }
    }

    public static void copy(GetterProducer source, SetterProducer target) {
        TypedGetterProducer typedSource = (TypedGetterProducer)source;
        Map<String, Function> getters = typedSource.getters();
        TypedSetterProducer typedTarget = (TypedSetterProducer)target;
        Map<String, BiConsumer> setters = typedTarget.setters();
        Objects2.copy(typedSource, typedTarget, getters, setters);
    }

    public static void copy(TypedGetterProducer source, TypedSetterProducer target) {
        Objects2.copy(source, target, source.getters(), target.setters());
    }

    public static <D extends SetterProducer> void clear(D bean) {
        Objects2.clear((TypedSetterProducer)bean);
    }

    public static <D extends TypedSetterProducer> void clear(D bean) {
        Map setters = bean.setters();
        for (BiConsumer<D, ?> biConsumer : setters.values()) {
            try {
                biConsumer.accept(bean, null);
            }
            catch (Exception e) {
                biConsumer.accept(bean, 0);
            }
        }
    }

    private static void copy(TypedGetterProducer source, TypedSetterProducer target, Map<String, Function> getters, Map<String, BiConsumer> setters) {
        for (Map.Entry<String, Function> entry : getters.entrySet()) {
            String propertyName = entry.getKey();
            BiConsumer setter = setters.get(propertyName);
            if (setter == null) continue;
            Function getter = entry.getValue();
            Object propertyValue = getter.apply(source);
            setter.accept(target, propertyValue);
        }
    }

    public static <T, O> O get(GetterProducer object, String propertyName, Map<String, Function<T, ?>> getters) {
        Function<GetterProducer, ?> getter = getters.get(propertyName);
        Objects.requireNonNull(getter, String.format("Can't find getter for property %s on %s", propertyName, object.getClass().getName()));
        return (O)getter.apply(object);
    }

    public static <T, O> void set(SetterProducer object, String propertyName, O propertyValue, Map<String, BiConsumer<T, ?>> setters) {
        BiConsumer<SetterProducer, ?> setter = setters.get(propertyName);
        Objects.requireNonNull(setter, String.format("Can't find a setter for property: %s on %s", propertyName, object.getClass().getName()));
        setter.accept(object, propertyValue);
    }

    public static void walk(ClassWalkVisitor visitor, Class<?> beanType) {
        new ClassWalker(visitor).visit(beanType);
    }

    private Objects2() {
    }

    static interface ClassWalkVisitor {
        public void onVisit(Class<?> var1);

        public boolean canContinue();
    }

    static class ClassWalker {
        private final ClassWalkVisitor visitor;
        private final Set<Class<?>> exploredTypes;

        ClassWalker(ClassWalkVisitor visitor) {
            this.visitor = visitor;
            this.exploredTypes = new LinkedHashSet();
        }

        public void visit(Class<?> beanType) {
            this.exploredTypes.clear();
            this.accept(beanType);
        }

        protected boolean accept(Class<?> beanType) {
            boolean canContinue;
            if (this.exploredTypes.contains(beanType)) {
                return this.visitor.canContinue();
            }
            this.exploredTypes.add(beanType);
            this.visitor.onVisit(beanType);
            if (!this.visitor.canContinue()) {
                return false;
            }
            if (beanType.getSuperclass() != null && !(canContinue = this.accept(beanType.getSuperclass()))) {
                return false;
            }
            for (Class<?> anInterface : beanType.getInterfaces()) {
                boolean canContinue2 = this.accept(anInterface);
                if (canContinue2) continue;
                return false;
            }
            return this.visitor.canContinue();
        }
    }
}

