/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public class SingletonSupplier<O>
implements Supplier<O>,
Closeable {
    private final Supplier<O> supplier;
    private O cache;

    public static <O> SingletonSupplier<O> of(Supplier<O> supplier) {
        return new SingletonSupplier<O>(supplier);
    }

    private SingletonSupplier(Supplier<O> supplier) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
    }

    @Override
    public O get() {
        if (this.cache == null) {
            this.cache = this.supplier.get();
        }
        return this.cache;
    }

    @Override
    public void close() {
        if (this.cache != null && this.cache instanceof Closeable) {
            try {
                ((Closeable)this.cache).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close " + this.cache, e);
            }
            finally {
                this.cache = null;
            }
        }
    }
}

