/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.beanutils.PropertyUtils;

public class Getters {
    public static final Predicate<PropertyDescriptor> IS_READ_DESCRIPTOR = input -> input.getReadMethod() != null;

    public static Set<String> getReadableProperties(Class<?> beanType) {
        HashSet exploredTypes = new HashSet();
        HashSet<String> result = new HashSet<String>();
        Getters.getReadableProperties(beanType, result, exploredTypes);
        result.remove("class");
        return result;
    }

    public static boolean isNestedReadableProperty(Class<?> beanType, String propertyName) {
        boolean result = propertyName.contains(".");
        if (result) {
            int dotIndex = propertyName.indexOf(".");
            String firstLevelProperty = propertyName.substring(0, dotIndex);
            Class<?> nestedType = Getters.getReadableType(beanType, firstLevelProperty);
            if (nestedType == null) {
                result = false;
            } else {
                String rest = propertyName.substring(dotIndex + 1);
                result = Getters.isNestedReadableProperty(nestedType, rest);
            }
        } else {
            Class<?> nestedType = Getters.getReadableType(beanType, propertyName);
            result = nestedType != null;
        }
        return result;
    }

    public static Class<?> getReadableType(Class<?> beanType, String propertyName) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(beanType);
        Class<?> result = null;
        for (PropertyDescriptor descriptor : descriptors) {
            String name = descriptor.getName();
            if (descriptor.getReadMethod() == null || !propertyName.equals(name)) continue;
            result = descriptor.getReadMethod().getReturnType();
            break;
        }
        if (result == null && beanType.getSuperclass() != null) {
            result = Getters.getReadableType(beanType.getSuperclass(), propertyName);
        }
        if (result == null) {
            Class<?> anInterface;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = beanType.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result = Getters.getReadableType(anInterface = classArray[i], propertyName)) == null; ++i) {
            }
        }
        return result;
    }

    private static void getReadableProperties(Class<?> beanType, Set<String> result, Set<Class<?>> exploredTypes) {
        Class<?>[] interfaces;
        if (exploredTypes.contains(beanType)) {
            return;
        }
        exploredTypes.add(beanType);
        Getters.getReadableProperties(beanType, result);
        if (beanType.getSuperclass() != null) {
            Getters.getReadableProperties(beanType.getSuperclass(), result, exploredTypes);
        }
        for (Class<?> anInterface : interfaces = beanType.getInterfaces()) {
            Getters.getReadableProperties(anInterface, result, exploredTypes);
        }
    }

    private static void getReadableProperties(Class<?> beanType, Set<String> result) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(beanType)) {
            String name = descriptor.getName();
            if (descriptor.getReadMethod() == null) continue;
            result.add(name);
        }
    }
}

