/*
 * Decompiled with CFR 0.152.
 */
package io.ultreia.java4all.lang;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.beanutils.PropertyUtils;

public class Setters {
    public static final Predicate<PropertyDescriptor> IS_WRITE_DESCRIPTOR = input -> input.getWriteMethod() != null;

    public static Set<String> getWriteableProperties(Class<?> beanType) {
        HashSet exploredTypes = new HashSet();
        HashSet<String> result = new HashSet<String>();
        Setters.getWriteableProperties(beanType, result, exploredTypes);
        return result;
    }

    public static Method getMutator(Object bean, String property) {
        Method mutator = null;
        if (bean == null) {
            throw new NullPointerException("could not find bean");
        }
        if (property == null) {
            throw new NullPointerException("could not find property");
        }
        try {
            PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)property);
            if (descriptor != null) {
                mutator = descriptor.getWriteMethod();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return mutator;
    }

    private static void getWriteableProperties(Class<?> beanType, Set<String> result, Set<Class<?>> exploredTypes) {
        Class<?>[] interfaces;
        if (exploredTypes.contains(beanType)) {
            return;
        }
        exploredTypes.add(beanType);
        Setters.getWriteableProperties(beanType, result);
        if (beanType.getSuperclass() != null) {
            Setters.getWriteableProperties(beanType.getSuperclass(), result, exploredTypes);
        }
        for (Class<?> anInterface : interfaces = beanType.getInterfaces()) {
            Setters.getWriteableProperties(anInterface, result, exploredTypes);
        }
    }

    private static void getWriteableProperties(Class<?> beanType, Set<String> result) {
        PropertyDescriptor[] descriptors;
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(beanType)) {
            String name = descriptor.getName();
            if (descriptor.getWriteMethod() == null) continue;
            result.add(name);
        }
    }
}

