/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.java.SystemOutLogProxy;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;

@Component(role=Template.class, hint="org.nuiton.eugene.java.JavaInterfaceTransformer")
public class JavaInterfaceTransformer
extends ObjectModelTransformerToJava {
    public void transformFromModel(ObjectModel model) {
        if (this.getLog() == null) {
            this.setLog(new SystemOutLogProxy());
        }
        super.transformFromModel(model);
    }

    public void transformFromInterface(ObjectModelInterface input) {
        boolean canGenerate = this.canGenerate(input);
        if (!canGenerate) {
            return;
        }
        ObjectModelInterface output = this.createInterface(input.getName(), input.getPackageName());
        this.getLog().debug("generate interface " + output.getQualifiedName());
        for (ObjectModelInterface extend : input.getInterfaces()) {
            this.addInterface((ObjectModelClassifier)output, extend.getQualifiedName());
        }
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            this.getLog().warn("[" + input.getName() + "] Will generate constants with NO prefix, not a good idea...");
        }
        this.setConstantPrefix(prefix);
        Set constants = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)output);
        for (ObjectModelAttribute attr : input.getAttributes()) {
            String constantName;
            if (attr.isStatic() || !StringUtils.isNotEmpty((CharSequence)attr.getDefaultValue()) || constants.contains(constantName = attr.getName())) continue;
            this.addConstant((ObjectModelClassifier)output, constantName, attr.getType(), attr.getDefaultValue(), (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        }
        JavaGeneratorUtil.cloneOperations((ObjectModelTransformerToJava)this, (Iterable)input.getOperations(), (ObjectModelClassifier)output, (boolean)false, (ObjectModelModifier[])new ObjectModelModifier[0]);
    }

    protected boolean canGenerate(ObjectModelInterface input) {
        boolean b;
        boolean bl = b = !this.getResourcesHelper().isJavaFileInClassPath(input.getQualifiedName());
        if (b) {
            b = input.getStereotypes().isEmpty();
        }
        return b;
    }
}

