/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import io.ultreia.java4all.i18n.I18n;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

@Component(role=TagValueMetadatasProvider.class, hint="eugene-java-templates")
@AutoService(value={TagValueMetadatasProvider.class})
public class EugeneJavaTagValues
extends DefaultTagValueMetadatasProvider {
    public String getDescription() {
        return I18n.t((String)"eugene.java.tagvalues", (Object[])new Object[0]);
    }

    public EugeneJavaTagValues() {
        super((TagValueMetadata[])Store.values());
    }

    public boolean isUseJava8(ObjectModel model) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.java8, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{model});
    }

    public boolean isBean(ObjectModelClassifier classifier, ObjectModelPackage aPackage) {
        return TagValueUtil.findBooleanTagValue((TagValueMetadata)Store.bean, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{classifier, aPackage});
    }

    public static enum Store implements TagValueMetadata
    {
        bean(I18n.n((String)"eugene.java.stereotype.bean", (Object[])new Object[0]), Boolean.TYPE, null, ObjectModelClassifier.class, ObjectModelPackage.class),
        java8(I18n.n((String)"eugene.java.tagvalue.java8", (Object[])new Object[0]), Boolean.TYPE, "true", ObjectModel.class);

        private final Set<Class<?>> targets;
        private final Class<?> type;
        private final String i18nDescriptionKey;
        private final String defaultValue;

        private Store(String i18nDescriptionKey, Class<?> type, String defaultValue, Class<?> ... targets) {
            this.targets = ImmutableSet.copyOf((Object[])targets);
            this.type = type;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name();
        }

        public Set<Class<?>> getTargets() {
            return this.targets;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<EqualsTagValueNameMatcher> getMatcherClass() {
            return EqualsTagValueNameMatcher.class;
        }

        public String getDescription() {
            return I18n.t((String)this.i18nDescriptionKey, (Object[])new Object[0]);
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDeprecated() {
            return false;
        }
    }
}

