/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.LogProxy;
import org.nuiton.eugene.java.BeanTransformerTagValues;
import org.nuiton.eugene.java.EugeneJavaTagValues;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class BeanTransformerContext {
    public final ImmutableMap<ObjectModelClass, String> classesNameTranslation;
    public final ImmutableMap<String, ObjectModelClass> classesByFqn;
    public final ImmutableList<String> classesFqn;
    public final ImmutableSet<ObjectModelClass> selectedClasses;
    public final ImmutableSet<ObjectModelClass> excludedClasses;
    public final ImmutableList<String> selectedClassesFqn;
    public final ImmutableMap<String, ObjectModelClass> selectedClassesByFqn;
    public final boolean useJava8;
    public final boolean useRelativeName;
    public final String[] relativeNameExcludes;
    private final LogProxy log;

    public BeanTransformerContext(ObjectModel model, EugeneCoreTagValues coreTagValues, EugeneJavaTagValues javaTemplatesTagValues, BeanTransformerTagValues beanTagValues, boolean includeAbstract, boolean includeSkip, Predicate<ObjectModelClass> extraPredicate, LogProxy log) {
        this.log = log;
        this.useJava8 = javaTemplatesTagValues.isUseJava8(model);
        this.useRelativeName = coreTagValues.isUseRelativeName(model);
        Set relativeNameExcludes = coreTagValues.getRelativeNameExcludes(model);
        this.relativeNameExcludes = relativeNameExcludes == null ? new String[]{} : relativeNameExcludes.toArray(new String[0]);
        ImmutableMap.Builder classesNameTranslationBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder classesBuilder = new ImmutableSet.Builder();
        ImmutableSet.Builder excludedClassesBuilder = new ImmutableSet.Builder();
        for (ObjectModelClass aClass : model.getClasses()) {
            ObjectModelPackage aPackage;
            if (!javaTemplatesTagValues.isBean((ObjectModelClassifier)aClass, aPackage = model.getPackage(aClass.getPackageName()))) continue;
            String classNamePrefix = beanTagValues.getClassNamePrefixTagValue((ObjectModelClassifier)aClass, aPackage, model);
            String classNameSuffix = beanTagValues.getClassNameSuffixTagValue((ObjectModelClassifier)aClass, aPackage, model);
            String generateName = JavaGeneratorUtil.generateName((String)classNamePrefix, (String)aClass.getName(), (String)classNameSuffix);
            classesNameTranslationBuilder.put((Object)aClass, (Object)generateName);
            if (!includeSkip && EugeneCoreTagValues.isSkip((ObjectModelClassifier)aClass, (ObjectModelPackage)aPackage)) {
                this.log.debug("Exclude by skip: " + aClass.getQualifiedName());
                excludedClassesBuilder.add((Object)aClass);
                continue;
            }
            if (!includeAbstract && aClass.isAbstract()) {
                this.log.debug("Exclude by abstract: " + aClass.getQualifiedName());
                excludedClassesBuilder.add((Object)aClass);
                continue;
            }
            if (extraPredicate != null && !extraPredicate.test(aClass)) {
                this.log.debug("Exclude by predicate: " + aClass.getQualifiedName());
                excludedClassesBuilder.add((Object)aClass);
                continue;
            }
            this.log.debug("Include: " + aClass.getQualifiedName());
            classesBuilder.add((Object)aClass);
        }
        this.classesNameTranslation = classesNameTranslationBuilder.build();
        this.selectedClasses = classesBuilder.build();
        this.excludedClasses = excludedClassesBuilder.build();
        this.classesByFqn = Maps.uniqueIndex((Iterable)this.classesNameTranslation.keySet(), ObjectModelClassifier::getQualifiedName);
        ArrayList classesFqn = new ArrayList(this.classesByFqn.keySet());
        Collections.sort(classesFqn);
        this.classesFqn = ImmutableList.copyOf(classesFqn);
        this.selectedClassesByFqn = Maps.uniqueIndex(this.selectedClasses, ObjectModelClassifier::getQualifiedName);
        ArrayList beanClassesFqn = new ArrayList(this.selectedClassesByFqn.keySet());
        Collections.sort(beanClassesFqn);
        this.selectedClassesFqn = ImmutableList.copyOf(beanClassesFqn);
    }

    public void report() {
        this.log.info(String.format("Found %d classes with \u00ab Bean \u00bb stereotype.", this.classesNameTranslation.size()));
        if (!this.excludedClasses.isEmpty()) {
            this.log.info(String.format("Skip excluded %d classes.", this.excludedClasses.size()));
        }
        this.log.info(String.format("Will apply on %d classes.", this.selectedClasses.size()));
    }
}

