/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.ultreia.java4all.bean.spi.GenerateJavaBeanDefinition;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.BeanTransformerContext;
import org.nuiton.eugene.java.BeanTransformerTagValues;
import org.nuiton.eugene.java.EugeneJavaTagValues;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.java.SystemOutLogProxy;
import org.nuiton.eugene.java.extension.ObjectModelAnnotation;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class BeanTransformer
extends ObjectModelTransformerToJava {
    protected final EugeneJavaTagValues javaTemplatesTagValues = new EugeneJavaTagValues();
    protected final BeanTransformerTagValues beanTagValues = new BeanTransformerTagValues();
    protected final EugeneCoreTagValues coreTagValues = new EugeneCoreTagValues();
    protected ImmutableMap<ObjectModelClass, String> helpersNameTranslation;
    protected ImmutableSet<ObjectModelClass> helpers;
    protected BeanTransformerContext context;

    public static boolean skipForInitializer(ObjectModelPackage aPackage, ObjectModelClass beanClass) {
        return beanClass.isAbstract() || EugeneCoreTagValues.isSkip((ObjectModelClassifier)beanClass, (ObjectModelPackage)aPackage);
    }

    public void transformFromModel(final ObjectModel model) {
        boolean generateInitializerRunnerClassName;
        boolean generateModelInitializer;
        if (this.getLog() == null) {
            this.setLog(new SystemOutLogProxy());
        }
        super.transformFromModel(model);
        final ImmutableMap.Builder helpersNameTranslationBuilder = new ImmutableMap.Builder();
        final ImmutableSet.Builder helpersBuilder = new ImmutableSet.Builder();
        this.context = new BeanTransformerContext(model, this.javaTemplatesTagValues, this.beanTagValues, true, true, new Predicate<ObjectModelClass>(){

            @Override
            public boolean test(ObjectModelClass aClass) {
                boolean canGenerateHelper;
                ObjectModelPackage aPackage = model.getPackage(aClass.getPackageName());
                boolean skip = EugeneCoreTagValues.isSkip((ObjectModelClassifier)aClass, (ObjectModelPackage)aPackage);
                boolean bl = canGenerateHelper = !skip && BeanTransformer.this.beanTagValues.isGenerateHelper((ObjectModelClassifier)aClass, aPackage, model);
                if (canGenerateHelper) {
                    helpersBuilder.add((Object)aClass);
                    String helperNamePrefix = BeanTransformer.this.beanTagValues.getHelperClassNamePrefixTagValue((ObjectModelClassifier)aClass, aPackage, model);
                    String helperNameSuffix = BeanTransformer.this.beanTagValues.getHelperClassNameSuffixTagValue((ObjectModelClassifier)aClass, aPackage, model);
                    String generateHelperName = JavaGeneratorUtil.generateName((String)helperNamePrefix, (String)aClass.getName(), (String)helperNameSuffix);
                    helpersNameTranslationBuilder.put((Object)aClass, (Object)generateHelperName);
                }
                return true;
            }
        }, this.getLog());
        this.context.report();
        this.helpers = helpersBuilder.build();
        this.helpersNameTranslation = helpersNameTranslationBuilder.build();
        String defaultPackageName = this.getDefaultPackageName();
        String modelBeanInitializeClassName = model.getName() + "ModelInitializer";
        boolean bl = generateModelInitializer = !this.getResourcesHelper().isJavaFileInClassPath(defaultPackageName + "." + modelBeanInitializeClassName);
        if (generateModelInitializer) {
            ObjectModelInterface anInterface = this.createInterface(modelBeanInitializeClassName, defaultPackageName);
            this.addOperation((ObjectModelClassifier)anInterface, "start", "void", new ObjectModelModifier[0]);
            this.addOperation((ObjectModelClassifier)anInterface, "end", "void", new ObjectModelModifier[0]);
            for (String fqn : this.context.selectedClassesFqn) {
                ObjectModelClass beanClass = (ObjectModelClass)this.context.selectedClassesByFqn.get((Object)fqn);
                if (BeanTransformer.skipForInitializer(((ObjectModel)this.getModel()).getPackage((ObjectModelClassifier)beanClass), beanClass)) continue;
                Object beanName = (String)this.context.classesNameTranslation.get((Object)beanClass);
                this.addImport((ObjectModelClassifier)anInterface, (String)beanName);
                this.addOperation((ObjectModelClassifier)anInterface, "init" + (String)beanName, "void", new ObjectModelModifier[0]);
            }
        }
        String modelInitializerRunnerClassName = model.getName() + "ModelInitializerRunner";
        boolean bl2 = generateInitializerRunnerClassName = !this.getResourcesHelper().isJavaFileInClassPath(defaultPackageName + "." + modelInitializerRunnerClassName);
        if (generateInitializerRunnerClassName) {
            ObjectModelClass aClass = this.createClass(modelInitializerRunnerClassName, defaultPackageName);
            StringBuilder bodyBuilder = new StringBuilder();
            bodyBuilder.append("\n        initializer.start();");
            for (String fqn : this.context.selectedClassesFqn) {
                ObjectModelClass beanClass = (ObjectModelClass)this.context.selectedClassesByFqn.get((Object)fqn);
                if (BeanTransformer.skipForInitializer(((ObjectModel)this.getModel()).getPackage((ObjectModelClassifier)beanClass), beanClass)) continue;
                String beanName = (String)this.context.classesNameTranslation.get((Object)beanClass);
                this.addImport((ObjectModelClassifier)aClass, beanName);
                bodyBuilder.append("\n        initializer.init" + beanName + "();");
            }
            bodyBuilder.append("\n        initializer.end();");
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)aClass, "init", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC});
            this.addParameter(operation, modelBeanInitializeClassName, "initializer");
            this.setOperationBody(operation, bodyBuilder.toString());
        }
    }

    public void transformFromClass(ObjectModelClass input) {
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        if (this.context.selectedClasses.contains((Object)input)) {
            boolean generateHelper;
            boolean generateGeneratedClass;
            if (EugeneCoreTagValues.isSkip((ObjectModelClassifier)input, (ObjectModelPackage)aPackage)) {
                return;
            }
            String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
            this.setConstantPrefix(prefix);
            String className = (String)this.context.classesNameTranslation.get((Object)input);
            String generatedClassName = "Generated" + className;
            boolean generateClass = this.notFoundInClassPath(input, className);
            if (generateClass) {
                this.generateClass(input, className, generatedClassName);
            }
            if (generateGeneratedClass = this.canGenerateAbstractClass(input, generatedClassName)) {
                this.generateGeneratedClass(aPackage, input, generatedClassName, className);
            }
            if (generateHelper = this.helpers.contains((Object)input)) {
                String helperClassName = (String)this.helpersNameTranslation.get((Object)input);
                String generatedHelperClassName = "Generated" + helperClassName;
                if (this.notFoundInClassPath(input, helperClassName)) {
                    this.generateHelper(input, generatedHelperClassName, helperClassName);
                }
                if (this.canGenerateAbstractClass(input, generatedHelperClassName)) {
                    this.generateGeneratedHelper(aPackage, input, className, generatedHelperClassName);
                }
            }
        }
    }

    protected ObjectModelClass generateClass(ObjectModelClass input, String className, String abstractClassName) {
        ObjectModelClass output = input.isAbstract() ? this.createAbstractClass(className, input.getPackageName()) : this.createClass(className, input.getPackageName());
        this.setSuperClass(output, abstractClassName);
        this.getLog().debug("will generate " + output.getQualifiedName());
        this.addSerializable(input, output, true);
        return output;
    }

    protected ObjectModelClass generateGeneratedClass(ObjectModelPackage aPackage, ObjectModelClass input, String className, String mainClassName) {
        String superClass = null;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                superClassIsBean = this.context.selectedClasses.contains((Object)superclass);
                if (superClassIsBean) {
                    superClass = superclass.getPackageName() + "." + (String)this.context.classesNameTranslation.get((Object)superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean && (superClass = this.beanTagValues.getSuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = this.createAbstractClass(className, input.getPackageName());
        if (this.beanTagValues.isAddJavaBeanAnnotation((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) {
            ObjectModelAnnotation objectModelAnnotation = this.addAnnotation((ObjectModelClassifier)output, (ObjectModelElement)output, GenerateJavaBeanDefinition.class);
            this.addAnnotationParameter((ObjectModelClassifier)output, objectModelAnnotation, "types", "{\"" + aPackage.getName() + "." + mainClassName + "\"}");
        }
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        this.getLog().debug("will generate " + output.getQualifiedName());
        boolean serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
        this.generateI18nBlockAndConstants(aPackage, input, (ObjectModelClassifier)output);
        this.addSerializable(input, output, serializableFound || superClassIsBean);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        boolean usePCS = this.beanTagValues.isGeneratePropertyChangeSupport((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateBooleanGetMethods = this.eugeneTagValues.isGenerateBooleanGetMethods((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateNotEmptyCollections = this.beanTagValues.isGenerateNotEmptyCollections((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods, generateNotEmptyCollections);
        }
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected void generateHelper(ObjectModelClass aClass, String abstractClassName, String defaultClassName) {
        String packageName = aClass.getPackageName();
        ObjectModelClass output = this.createClass(defaultClassName, packageName);
        this.setSuperClass(output, packageName + "." + abstractClassName);
        this.getLog().debug("will generate " + output.getQualifiedName());
    }

    protected void generateGeneratedHelper(ObjectModelPackage aPackage, ObjectModelClass aClass, String typeName, String abstractClassName) {
        boolean generateFunctions;
        boolean generateConstructors;
        ObjectModelClass output = this.createAbstractClass(abstractClassName, aPackage.getName());
        String superClassName = this.getGeneratedHelperSuperClassName(aPackage, aClass);
        if (StringUtils.isNotBlank((CharSequence)superClassName)) {
            this.setSuperClass(output, superClassName);
        }
        this.getLog().debug("will generate " + output.getQualifiedName());
        this.addImport((ObjectModelClassifier)output, Binder.class);
        this.addImport((ObjectModelClassifier)output, BinderFactory.class);
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeName + ".class;\n    ");
        boolean bl = generateConstructors = this.beanTagValues.isGenerateHelperConstructors((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model) && !aClass.isAbstract();
        if (generateConstructors) {
            this.generateGeneratedHelperConstructors(output, typeName);
        }
        this.generateGeneratedHelperCopyMethods(output, typeName);
        boolean generatePredicates = this.beanTagValues.isGenerateHelperPredicates((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
        if (generatePredicates) {
            this.generateGeneratedHelperPredicates(aClass, output, typeName);
        }
        if (generateFunctions = this.beanTagValues.isGenerateHelperFunctions((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model)) {
            this.generateGeneratedHelperFunctions(aClass, output, typeName);
        }
    }

    protected void generateGeneratedHelperConstructors(ObjectModelClass output, String typeName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return new " + typeName + "();\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);\n        BeanType result = new" + typeName + "(source, binder);\n        return result;\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
        this.setOperationBody(operation, "\n        BeanType result = (BeanType) new" + typeName + "();\n        binder.copy(source, result);\n        return result;\n    ");
    }

    protected void generateGeneratedHelperCopyMethods(ObjectModelClass output, String typeName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "copy" + typeName, "<BeanType extends " + typeName + "> void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.addParameter(operation, "BeanType", "target");
        this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n        Binder<BeanType, BeanType> binder = BinderFactory.newBinder(sourceType);\n        binder.copy(source, target);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "copy" + typeName, "<BeanType extends " + typeName + "> void", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "BeanType", "source");
        this.addParameter(operation, "BeanType", "target");
        this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
        this.setOperationBody(operation, "\n        binder.copy(source, target);\n    ");
    }

    protected void generateGeneratedHelperPredicates(ObjectModelClass input, ObjectModelClass output, String typeName) {
        boolean atLeastOnePropertyFound = false;
        for (ObjectModelAttribute attribute : this.getProperties(input)) {
            boolean multiple = JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute);
            if (multiple) continue;
            atLeastOnePropertyFound = true;
            String attrName = this.getAttributeName(attribute);
            String attrType = this.getAttributeTypeWithGeneric(attribute);
            this.addImport((ObjectModelClassifier)output, attrType);
            String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
            String capitalizeAttrName = JavaGeneratorUtil.capitalizeJavaBeanPropertyName((String)attrName);
            String newPreficateMethodName = "new" + capitalizeAttrName + "Predicate";
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, newPreficateMethodName, "<BeanType extends " + typeName + "> Predicate<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, simpleType, attrName);
            String getterName = this.getGetterName(attribute, attrName);
            if (this.context.useJava8) {
                this.setOperationBody(operation, "\n        return o -> Objects.equals(" + attrName + ", o." + getterName + "());\n\n    ");
            } else {
                this.setOperationBody(operation, "\n        final " + simpleType + " $tmp = " + attrName + ";\n        return new Predicate<BeanType>() {\n\n            @Override\n            public boolean apply(BeanType input) {\n                return Objects.equal($tmp, input." + getterName + "());\n            }\n        };\n\n    ");
            }
            operation = this.addOperation((ObjectModelClassifier)output, "filterBy" + capitalizeAttrName, "<BeanType extends " + typeName + "> List<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Collection<BeanType>", "$source");
            this.addParameter(operation, simpleType, attrName);
            if (this.context.useJava8) {
                this.setOperationBody(operation, "\n        return $source.stream().filter(" + newPreficateMethodName + "(" + attrName + ")).collect(Collectors.toList());\n    ");
                continue;
            }
            this.addImport((ObjectModelClassifier)output, Collection.class);
            this.addImport((ObjectModelClassifier)output, List.class);
            this.addImport((ObjectModelClassifier)output, Lists.class);
            this.setOperationBody(operation, "\n        return Lists.newArrayList(Iterables.filter($source, " + newPreficateMethodName + "(" + attrName + ")));\n    ");
        }
        if (atLeastOnePropertyFound) {
            if (this.context.useJava8) {
                this.addImport((ObjectModelClassifier)output, Collection.class);
                this.addImport((ObjectModelClassifier)output, List.class);
                this.addImport((ObjectModelClassifier)output, "java.util.Objects");
                this.addImport((ObjectModelClassifier)output, "java.util.function.Predicate");
                this.addImport((ObjectModelClassifier)output, "java.util.stream.Collectors");
            } else {
                this.addImport((ObjectModelClassifier)output, Objects.class);
                this.addImport((ObjectModelClassifier)output, com.google.common.base.Predicate.class);
                this.addImport((ObjectModelClassifier)output, Iterables.class);
            }
            this.addImport((ObjectModelClassifier)output, Iterable.class);
        }
    }

    protected void generateGeneratedHelperFunctions(ObjectModelClass input, ObjectModelClass output, String typeName) {
        boolean atLeastOnePropertyFound = false;
        boolean useJava8 = this.context.useJava8;
        for (ObjectModelAttribute attribute : this.getProperties(input)) {
            ObjectModelOperation operation;
            boolean multiple = JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute);
            if (multiple) continue;
            atLeastOnePropertyFound = true;
            String attrName = this.getAttributeName(attribute);
            String attrType = this.getAttributeTypeWithGeneric(attribute);
            this.addImport((ObjectModelClassifier)output, attrType);
            String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
            simpleType = this.wrapPrimitiveType(simpleType);
            String capitalizeAttrName = JavaGeneratorUtil.capitalizeJavaBeanPropertyName((String)attrName);
            String getterName = this.getGetterName(attribute, attrName);
            String newFunctionMethodName = "new" + capitalizeAttrName + "Function";
            String getFunctionMethodName = "get" + capitalizeAttrName + "Function";
            String functionTypeName = "Function<BeanType, " + simpleType + ">";
            String functionFieldName = JavaGeneratorUtil.convertVariableNameToConstantName((String)(capitalizeAttrName + "Function"));
            this.addAttribute((ObjectModelClassifier)output, functionFieldName, "Function<" + typeName + ", " + simpleType + ">", useJava8 ? typeName + "::" + getterName : newFunctionMethodName + "()", new ObjectModelModifier[]{ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.STATIC, useJava8 ? ObjectModelJavaModifier.PUBLIC : ObjectModelJavaModifier.PROTECTED});
            if (!useJava8) {
                operation = this.addOperation((ObjectModelClassifier)output, getFunctionMethodName, "<BeanType extends " + typeName + "> " + functionTypeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
                this.setOperationBody(operation, "\n        return (" + functionTypeName + ") " + functionFieldName + ";\n\n    ");
                operation = this.addOperation((ObjectModelClassifier)output, newFunctionMethodName, "<BeanType extends " + typeName + "> " + functionTypeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
                this.setOperationBody(operation, "\n    return new " + functionTypeName + "() {\n\n        @Override\n        public " + simpleType + " apply(BeanType input) {\n            return input." + getterName + "();\n        }\n    };\n\n");
            }
            operation = this.addOperation((ObjectModelClassifier)output, "uniqueIndexBy" + capitalizeAttrName, "<BeanType extends " + typeName + "> ImmutableMap<" + simpleType + ", BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "Iterable<BeanType>", "$source");
            if (useJava8) {
                this.setOperationBody(operation, "\n        return Maps.uniqueIndex($source, " + functionFieldName + "::apply);\n    ");
                continue;
            }
            this.setOperationBody(operation, "\n        return Maps.uniqueIndex($source, " + functionFieldName + ");\n    ");
        }
        if (atLeastOnePropertyFound) {
            if (useJava8) {
                this.addImport((ObjectModelClassifier)output, "java.util.function.Function");
                this.addImport((ObjectModelClassifier)output, "java.util.Objects");
            } else {
                this.addImport((ObjectModelClassifier)output, Function.class);
                this.addImport((ObjectModelClassifier)output, Iterables.class);
                this.addImport((ObjectModelClassifier)output, Objects.class);
            }
            this.addImport((ObjectModelClassifier)output, ImmutableMap.class);
            this.addImport((ObjectModelClassifier)output, Iterable.class);
            this.addImport((ObjectModelClassifier)output, Maps.class);
        }
    }

    protected String getGeneratedHelperSuperClassName(ObjectModelPackage aPackage, ObjectModelClass aClass) {
        String superClassName = null;
        boolean superClassIsBean = false;
        Collection superclasses = aClass.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                superClassIsBean = this.helpers.contains((Object)superclass);
                if (superClassIsBean) {
                    superClassName = superclass.getPackageName() + "." + (String)this.helpersNameTranslation.get((Object)superclass);
                    break;
                }
                superClassName = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean) {
            superClassName = this.beanTagValues.getHelperSuperClassTagValue((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
        }
        return superClassName;
    }

    protected String getAttributeType(ObjectModelAttribute attr) {
        String attrType = attr.getType();
        if (attr.hasAssociationClass()) {
            attrType = attr.getAssociationClass().getName();
        }
        return this.getAttributeType(attrType);
    }

    protected String getAttributeType(String attrType) {
        ObjectModelClass attributeClass;
        String attributeType;
        boolean hasClass;
        if (!JavaGeneratorUtil.isPrimitiveType((String)attrType) && (hasClass = ((ObjectModel)this.model).hasClass(attrType)) && (attributeType = (String)this.context.classesNameTranslation.get((Object)(attributeClass = ((ObjectModel)this.model).getClass(attrType)))) != null) {
            attrType = attributeClass.getPackageName() + "." + attributeType;
        }
        return attrType;
    }

    protected boolean notFoundInClassPath(ObjectModelClass input, String className) {
        String fqn = input.getPackageName() + "." + className;
        boolean inClassPath = this.getResourcesHelper().isJavaFileInClassPath(fqn);
        return !inClassPath;
    }

    protected void createProperty(ObjectModelClass output, ObjectModelAttribute attr, boolean usePCS, boolean generateBooleanGetMethods, boolean generateNotEmptyCollections) {
        String attrName = this.getAttributeName(attr);
        String attrType = this.getAttributeTypeWithGeneric(attr);
        boolean multiple = JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr);
        String constantName = this.getConstantName(attrName);
        String simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
        if (multiple) {
            this.createGetChildMethod(output, attrName, attrType, simpleType);
            this.createIsEmptyMethod(output, attrName);
            this.createSizeMethod(output, attrName);
            this.createAddChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createAddAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            this.createRemoveChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createRemoveAllChildrenMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsChildMethod(output, attrName, attrType, constantName, usePCS);
            this.createContainsAllChildrenMethod(output, attrName, attrType, constantName);
            attrType = JavaGeneratorUtil.getAttributeInterfaceType((ObjectModelParameter)attr, (String)this.getAttributeTypeWithGeneric(attr), (boolean)true);
            simpleType = JavaGeneratorUtil.getSimpleName((String)attrType);
        }
        boolean booleanProperty = JavaGeneratorUtil.isBooleanPrimitive((ObjectModelAttribute)attr);
        if (multiple) {
            String collectionImplementationType = JavaGeneratorUtil.getAttributeImplementationType((ObjectModelParameter)attr, (String)this.getAttributeTypeWithGeneric(attr), (boolean)true);
            this.createGetMethod(output, attrName, attrType, "get", generateNotEmptyCollections, collectionImplementationType);
        } else {
            if (booleanProperty) {
                this.createGetMethod(output, attrName, attrType, "is");
            }
            if (!booleanProperty || generateBooleanGetMethods) {
                this.createGetMethod(output, attrName, attrType, "get");
            }
        }
        this.createSetMethod(output, attrName, attrType, simpleType, constantName, usePCS);
        this.addAttribute((ObjectModelClassifier)output, attrName, attrType, "", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
    }

    protected List<ObjectModelAttribute> getProperties(ObjectModelClass input) {
        List attributes = (List)input.getAttributes();
        ArrayList<ObjectModelAttribute> attrs = new ArrayList<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable()) continue;
            attrs.add(attr);
        }
        return attrs;
    }

    protected void createGetMethod(ObjectModelClass output, String attrName, String attrType, String methodPrefix, boolean generateLayzCode, String collectionImplementationType) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName(methodPrefix, attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        if (generateLayzCode) {
            this.addImport((ObjectModelClassifier)output, collectionImplementationType);
            String implementationSimpleType = JavaGeneratorUtil.getSimpleName((String)collectionImplementationType);
            this.setOperationBody(operation, "\n    if (" + attrName + " == null) {\n        " + attrName + " = new " + implementationSimpleType + "();\n    }\n    return " + attrName + ";\n");
        } else {
            this.setOperationBody(operation, "\n    return " + attrName + ";\n");
        }
    }

    protected void createGetMethod(ObjectModelClass output, String attrName, String attrType, String methodPrefix) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName(methodPrefix, attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + ";\n    ");
    }

    protected void createGetChildMethod(ObjectModelClass output, String attrName, String attrType, String simpleType) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("get", attrName), attrType, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "int", "index");
        this.setOperationBody(operation, "\n        " + simpleType + " o = getChild(" + attrName + ", index);\n        return o;\n    ");
    }

    protected void createIsEmptyMethod(ObjectModelClass output, String attrName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("is", attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + " == null || " + attrName + ".isEmpty();\n    ");
    }

    protected void createSizeMethod(ObjectModelClass output, String attrName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("size", attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.setOperationBody(operation, "\n        return " + attrName + " == null ? 0 : " + attrName + ".size();\n    ");
    }

    protected void createAddChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("add", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder("\n        " + methodName + "().add(" + attrName + ");\n    ");
        if (usePCS) {
            buffer.append("    firePropertyChange(" + constantName + ", null, " + attrName + ");\n    ");
        }
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createAddAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("addAll", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder("\n        " + methodName + "().addAll(" + attrName + ");\n    ");
        if (usePCS) {
            buffer.append("    firePropertyChange(" + constantName + ", null, " + attrName + ");\n    ");
        }
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("remove", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        String methodName = this.getJavaBeanMethodName("get", attrName);
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n        boolean removed = " + methodName + "().remove(" + attrName + ");");
        if (usePCS) {
            buffer.append("\n        if (removed) {\n            firePropertyChange(" + constantName + ", " + attrName + ", null);\n        }");
        }
        buffer.append("\n        return removed;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createRemoveAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("removeAll", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean  removed = " + methodName + "().removeAll(" + attrName + ");");
        if (usePCS) {
            buffer.append("\n        if (removed) {\n            firePropertyChange(" + constantName + ", " + attrName + ", null);\n        }");
        }
        buffer.append("\n        return removed;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsChildMethod(ObjectModelClass output, String attrName, String attrType, String constantName, boolean usePCS) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("contains", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean contains = " + methodName + "().contains(" + attrName + ");\n        return contains;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createContainsAllChildrenMethod(ObjectModelClass output, String attrName, String attrType, String constantName) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("containsAll", attrName), "boolean", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, "java.util.Collection<" + attrType + ">", attrName);
        StringBuilder buffer = new StringBuilder();
        String methodName = this.getJavaBeanMethodName("get", attrName);
        buffer.append("\n        boolean  contains = " + methodName + "().containsAll(" + attrName + ");\n        return contains;\n    ");
        this.setOperationBody(operation, buffer.toString());
    }

    protected void createSetMethod(ObjectModelClass output, String attrName, String attrType, String simpleType, String constantName, boolean usePCS) {
        boolean booleanProperty = GeneratorUtil.isBooleanPrimitive((String)simpleType);
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, this.getJavaBeanMethodName("set", attrName), "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, attrType, attrName);
        if (usePCS) {
            String methodPrefix = "get";
            if (booleanProperty) {
                methodPrefix = "is";
            }
            String methodName = this.getJavaBeanMethodName(methodPrefix, attrName);
            this.setOperationBody(operation, "\n        " + simpleType + " oldValue = " + methodName + "();\n        this." + attrName + " = " + attrName + ";\n        firePropertyChange(" + constantName + ", oldValue, " + attrName + ");\n    ");
        } else {
            this.setOperationBody(operation, "\n        this." + attrName + " = " + attrName + ";\n    ");
        }
    }

    protected void addSerializable(ObjectModelClass input, ObjectModelClass output, boolean interfaceFound) {
        if (!interfaceFound) {
            this.addInterface((ObjectModelClassifier)output, Serializable.class);
        }
        long serialVersionUID = JavaGeneratorUtil.generateSerialVersionUID((ObjectModelClassifier)input);
        this.addConstant((ObjectModelClassifier)output, "serialVersionUID", "long", serialVersionUID + "L", (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
    }

    protected boolean addInterfaces(ObjectModelClass input, ObjectModelClassifier output, String extraInterfaceName) {
        boolean foundSerializable = false;
        HashSet<String> added = new HashSet<String>();
        for (ObjectModelInterface parentInterface : input.getInterfaces()) {
            String fqn = parentInterface.getQualifiedName();
            added.add(fqn);
            this.addInterface(output, fqn);
            if (!Serializable.class.getName().equals(fqn)) continue;
            foundSerializable = true;
        }
        if (extraInterfaceName != null && !added.contains(extraInterfaceName)) {
            this.addInterface(output, extraInterfaceName);
        }
        return foundSerializable;
    }

    protected void createPropertyChangeSupport(ObjectModelClass output) {
        this.addAttribute((ObjectModelClassifier)output, "pcs", PropertyChangeSupport.class, "new PropertyChangeSupport(this)", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED, ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.TRANSIENT});
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.addPropertyChangeListener(listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.addPropertyChangeListener(propertyName, listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.removePropertyChangeListener(listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PUBLIC});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, PropertyChangeListener.class, "listener");
        this.setOperationBody(operation, "\n        pcs.removePropertyChangeListener(propertyName, listener);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, Object.class, "oldValue");
        this.addParameter(operation, Object.class, "newValue");
        this.setOperationBody(operation, "\n        pcs.firePropertyChange(propertyName, oldValue, newValue);\n    ");
        operation = this.addOperation((ObjectModelClassifier)output, "firePropertyChange", "void", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addParameter(operation, String.class, "propertyName");
        this.addParameter(operation, Object.class, "newValue");
        this.setOperationBody(operation, "\n        firePropertyChange(propertyName, null, newValue);\n    ");
    }

    protected void createGetChildMethod(ObjectModelClass output) {
        ObjectModelOperation getChild = this.addOperation((ObjectModelClassifier)output, "getChild", "<T> T", new ObjectModelModifier[]{ObjectModelJavaModifier.PROTECTED});
        this.addImport((ObjectModelClassifier)output, List.class);
        this.addParameter(getChild, "java.util.Collection<T>", "childs");
        this.addParameter(getChild, "int", "index");
        this.setOperationBody(getChild, "\n        T result = null;\n        if (childs != null) {\n            if (childs instanceof List) {\n                if (index < childs.size()) {\n                    result = ((List<T>) childs).get(index);\n                }\n            } else {\n                int i = 0;\n                for (T o : childs) {\n                    if (index == i) {\n                        result = o;\n                        break;\n                    }\n                    i++;\n                }\n            }\n        }\n        return result;\n");
    }

    protected void generateI18nBlockAndConstants(ObjectModelPackage aPackage, ObjectModelClass input, ObjectModelClassifier output) {
        String i18nPrefix = this.eugeneTagValues.getI18nPrefixTagValue((ObjectModelElement)input, aPackage, (ObjectModel)this.model);
        if (!StringUtils.isEmpty((CharSequence)i18nPrefix)) {
            this.generateI18nBlock((ObjectModelClassifier)input, output, i18nPrefix);
        }
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
        this.setConstantPrefix(prefix);
        Set constantNames = this.addConstantsFromDependency((ObjectModelClassifier)input, output);
        for (ObjectModelAttribute attr : this.getProperties(input)) {
            this.createPropertyConstant(output, attr, prefix, constantNames);
        }
    }

    protected void addDefaultMethodForNoneBeanSuperClass(ObjectModelClass output, boolean usePCS, List<ObjectModelAttribute> properties) {
        boolean hasAMultipleProperty;
        if (usePCS) {
            this.createPropertyChangeSupport(output);
        }
        if (hasAMultipleProperty = this.containsMultiple(properties)) {
            this.createGetChildMethod(output);
        }
    }

    protected String wrapPrimitiveType(String attrType) {
        if (JavaGeneratorUtil.isPrimitiveType((String)attrType)) {
            attrType = JavaGeneratorUtil.getPrimitiveWrapType((String)attrType);
        }
        return attrType;
    }

    protected String getGetterName(ObjectModelAttribute attribute, String attrName) {
        boolean booleanProperty = JavaGeneratorUtil.isBooleanPrimitive((ObjectModelAttribute)attribute);
        String methodPrefix = "get";
        if (booleanProperty) {
            methodPrefix = "is";
        }
        return this.getJavaBeanMethodName(methodPrefix, attrName);
    }

    protected boolean canGenerateAbstractClass(ObjectModelClass aClass, String abstractClassName) {
        boolean inClassPath;
        boolean bl = inClassPath = !this.notFoundInClassPath(aClass, abstractClassName);
        if (inClassPath) {
            throw new IllegalStateException(String.format("Can't generate %s, already found in class-path, this is a generated class, you should not ovveride it.\n\nPlease remove it from class path and use the %s class instead.", aClass.getPackageName() + "." + abstractClassName, aClass));
        }
        return true;
    }

    protected void createPropertyConstant(ObjectModelClassifier output, ObjectModelAttribute attr, String prefix, Set<String> constantNames) {
        String attrName = this.getAttributeName(attr);
        String constantName = prefix + this.builder.getConstantName(attrName);
        if (!constantNames.contains(constantName)) {
            this.addConstant(output, constantName, String.class, "\"" + attrName + "\"", (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        }
    }

    protected String getAttributeName(ObjectModelAttribute attr) {
        String attrName = attr.getName();
        if (attr.hasAssociationClass()) {
            String assocAttrName = JavaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            attrName = JavaGeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
        }
        return attrName;
    }

    protected String getAttributeTypeWithGeneric(ObjectModelAttribute attr) {
        String attrType = this.getAttributeType(attr);
        String generic = this.eugeneTagValues.getAttributeGenericTagValue(attr);
        if (generic != null) {
            attrType = attrType + "<" + this.getAttributeType(generic) + ">";
        }
        return attrType;
    }

    protected boolean containsMultiple(List<ObjectModelAttribute> attributes) {
        boolean result = false;
        for (ObjectModelAttribute attr : attributes) {
            if (!JavaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            result = true;
            break;
        }
        return result;
    }
}

