/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.util.Collection;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.java.SystemOutLogProxy;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelPackage;

public class JavaEnumerationTransformer
extends ObjectModelTransformerToJava {
    public void transformFromModel(ObjectModel model) {
        if (this.getLog() == null) {
            this.setLog(new SystemOutLogProxy());
        }
        super.transformFromModel(model);
    }

    public void transformFromEnumeration(ObjectModelEnumeration input) {
        if (!this.canGenerate(input)) {
            this.getLog().debug("Skip generation for " + input.getQualifiedName());
            return;
        }
        ObjectModelEnumeration output = this.createEnumeration(input.getName(), input.getPackageName());
        this.getLog().debug("will generate " + output.getQualifiedName());
        Collection literals = input.getLiterals();
        for (String literal : literals) {
            this.addLiteral(output, literal);
        }
    }

    protected boolean canGenerate(ObjectModelEnumeration input) {
        boolean b;
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        boolean bl = b = !EugeneCoreTagValues.isSkip((ObjectModelClassifier)input, (ObjectModelPackage)aPackage);
        if (b) {
            b = !this.getResourcesHelper().isJavaFileInClassPath(input.getQualifiedName());
        }
        return b;
    }
}

