/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterData;
import org.nuiton.eugene.writer.FileGrabber;

public class FileGrabberFromDirectory
implements FileGrabber {
    private static final Logger log = LogManager.getLogger(FileGrabberFromDirectory.class);
    private final ChainedFileWriterConfiguration configuration;

    public FileGrabberFromDirectory(ChainedFileWriterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void addFilesToTreate(File extractDirectory, String inputDirectory, Set<String> includePatterns, ChainedFileWriterData result) throws IOException {
        Map<File, List<File>> filesByRoot = result.getFilesByRoot();
        Map<File, List<File>> resourcesByFile = result.getResourcesByFile();
        File realInputDirectory = new File(inputDirectory);
        List<File> files = filesByRoot.get(realInputDirectory);
        if (files == null) {
            files = new ArrayList<File>();
            filesByRoot.put(realInputDirectory, files);
        }
        List<File> newFiles = this.getFiles(inputDirectory, includePatterns);
        for (File file : newFiles) {
            files.add(file);
            File resourceFile = this.getAssociatedResource(file);
            if (resourceFile == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug("[" + file + "] No resource associated.");
                continue;
            }
            if (this.configuration.isVerbose() && log.isDebugEnabled()) {
                log.debug("[" + file + "] Detected resource " + resourceFile);
            }
            ArrayList<File> resources = new ArrayList<File>(1);
            resources.add(resourceFile);
            resourcesByFile.put(file, resources);
        }
    }

    protected List<File> getFiles(String inputPath, Set<String> includePattern) {
        if (CollectionUtils.isEmpty(includePattern)) {
            throw new IllegalArgumentException("Must have at least one include pattern");
        }
        ArrayList<File> result = new ArrayList<File>();
        DirectoryScanner ds = new DirectoryScanner();
        File inputDirectory = new File(inputPath);
        ds.setBasedir(inputDirectory);
        ds.setIncludes(includePattern.toArray(new String[includePattern.size()]));
        ds.setExcludes(null);
        ds.addDefaultExcludes();
        ds.scan();
        for (String file : ds.getIncludedFiles()) {
            File in = new File(inputDirectory, file);
            result.add(in);
        }
        return result;
    }

    protected File getAssociatedResource(File file) throws IOException {
        File propertiesFile;
        String extension = "." + FileUtils.extension((String)file.getName());
        String path = file.getAbsolutePath();
        String filename = StringUtils.substring((String)path, (int)0, (int)(-extension.length())).concat(".properties");
        if (log.isDebugEnabled()) {
            log.info("path of file : " + path);
            log.info("path of resource : " + filename);
        }
        if (!(propertiesFile = new File(filename)).exists()) {
            propertiesFile = null;
        }
        return propertiesFile;
    }
}

