/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.writer;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.eugene.writer.AbstractChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.eugene.writer.ChainedFileWriterData;
import org.nuiton.eugene.writer.ChainedFileWriterEntry;
import org.nuiton.eugene.writer.ChainedWriterEngine;
import org.nuiton.eugene.writer.FileGrabber;
import org.nuiton.eugene.writer.FileGrabberFromClassPath;
import org.nuiton.eugene.writer.FileGrabberFromDirectory;

@Component(role=ChainedWriterEngine.class, hint="default")
public class DefaultChainedWriterEngine
implements ChainedWriterEngine {
    private static final Logger log = LogManager.getLogger(DefaultChainedWriterEngine.class);
    protected ChainedFileWriterConfiguration configuration;
    protected Set<ChainedFileWriter> availableWriters;
    protected List<ChainedFileWriter> selectedWriters;
    private FileGrabberFromDirectory fileGrabberFromDirectory;
    private FileGrabberFromClassPath fileGrabberFromClassPath;

    public ChainedFileWriterConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public List<ChainedFileWriter> getSelectedWriters() {
        if (this.selectedWriters == null) {
            this.checkInit("getSelectedWriters");
            this.selectedWriters = new ArrayList<ChainedFileWriter>();
        }
        return this.selectedWriters;
    }

    @Override
    public boolean containsWriter(String inputProtocol) {
        for (ChainedFileWriter w : this.getSelectedWriters()) {
            if (!inputProtocol.equals(w.getInputProtocol())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ChainedFileWriter> getAvailableWriters() {
        if (this.availableWriters == null) {
            this.checkInit("getAvailableWriters");
            this.availableWriters = this.filterWriterForModelType(this.getConfiguration().getWriters(), this.getConfiguration().getModelType());
        }
        return this.availableWriters;
    }

    @Override
    public void registerInclude(String include) {
        ChainedFileWriter nextWriter;
        ChainedFileWriterConfiguration configuration;
        String modelType;
        String outpoutProtocol;
        this.checkInit("registerInclude");
        List<ChainedFileWriter> selectedWriters = this.getSelectedWriters();
        if (log.isDebugEnabled()) {
            log.debug(">>>>>>>>>>>>>>>>> [" + include + "]");
            log.debug("Will register include [" + include + "]");
            log.debug("actual selected writers : " + selectedWriters);
        }
        ModelFileWriterEntryType selectedType = null;
        Matcher matcher = null;
        for (ModelFileWriterEntryType type : ModelFileWriterEntryType.values()) {
            matcher = type.getMatcher(include);
            if (matcher == null) continue;
            selectedType = type;
            break;
        }
        if (selectedType == null) {
            throw new IllegalArgumentException("could not find a writer for include pattern : " + include);
        }
        ChainedFileWriter writer = selectedType.getWriter(this, include, matcher);
        ChainedFileWriterEntry writerEntry = selectedType.newEntry(this, include, matcher, writer);
        writer.addEntry(writerEntry);
        if (!selectedWriters.contains(writer)) {
            if (log.isDebugEnabled()) {
                log.debug("[" + include + "] Associated with writer " + writer);
            }
            selectedWriters.add(writer);
        }
        if ((outpoutProtocol = writer.getOutputProtocol(modelType = (configuration = this.getConfiguration()).getModelType())) == null) {
            if (log.isDebugEnabled()) {
                log.debug("<<<<<<<<<<<<<<<<< [" + include + "]");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[" + include + "] writer " + writer.getClass().getSimpleName() + " require a next writer of protocol " + outpoutProtocol);
        }
        if ((nextWriter = ((AbstractChainedFileWriter)writer).getNextWriter()) == null) {
            nextWriter = this.getWriterForInputProtocol(this.getAvailableWriters(), outpoutProtocol, modelType);
            if (nextWriter == null) {
                throw new IllegalArgumentException("could not find a writer for protocole " + outpoutProtocol + " on model " + modelType);
            }
            ((AbstractChainedFileWriter)writer).setNextWriter(nextWriter);
        }
        String basedirpath = configuration.getBasedir().getAbsolutePath();
        String outputpath = writer.getOutputDirectory(configuration.getOutputDirectory(), configuration.isTestPhase()).getAbsolutePath();
        String path = outputpath.substring(basedirpath.length() + 1);
        String newInclude = outpoutProtocol + ":" + path + ":" + nextWriter.getDefaultIncludes();
        this.registerInclude(newInclude);
        if (log.isDebugEnabled()) {
            log.debug("<<<<<<<<<<<<<<<<< [" + include + "]");
        }
    }

    @Override
    public void clear() {
        if (this.selectedWriters != null) {
            this.selectedWriters.clear();
            this.selectedWriters = null;
        }
        if (this.availableWriters != null) {
            for (ChainedFileWriter writer : this.availableWriters) {
                writer.clear();
            }
            this.availableWriters.clear();
            this.availableWriters = null;
        }
        this.configuration = null;
        this.fileGrabberFromDirectory = null;
        this.fileGrabberFromClassPath = null;
    }

    @Override
    public void init(ChainedFileWriterConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration, (Object)"Configuration can not be null");
        this.configuration = configuration;
        this.fileGrabberFromDirectory = new FileGrabberFromDirectory(configuration);
        this.fileGrabberFromClassPath = new FileGrabberFromClassPath(configuration);
    }

    @Override
    public Set<ChainedFileWriter> filterWriterForModelType(Map<String, ChainedFileWriter> universe, String modelType) {
        HashSet<ChainedFileWriter> result = new HashSet<ChainedFileWriter>();
        for (ChainedFileWriter w : universe.values()) {
            if (!w.acceptModel(modelType)) continue;
            if (log.isDebugEnabled()) {
                log.debug("writer [" + w + "] accept model " + modelType);
            }
            result.add(w);
        }
        return result;
    }

    @Override
    public ChainedFileWriter getWriterForInputProtocol(Set<ChainedFileWriter> universe, String inputProtocol, String modelType) {
        for (ChainedFileWriter writer : universe) {
            if (!inputProtocol.equals(writer.getInputProtocol(modelType))) continue;
            return writer;
        }
        return null;
    }

    @Override
    public ChainedFileWriter getWriterForInclude(Set<ChainedFileWriter> universe, String include, String modelType) {
        for (ChainedFileWriter w : universe) {
            if (!w.acceptInclude(include)) continue;
            return w;
        }
        return null;
    }

    @Override
    public ChainedFileWriterData getData(ChainedFileWriter writer) throws IOException {
        this.checkInit("getData");
        File outputDir = writer.getOutputDirectory(this.configuration.getOutputDirectory(), this.configuration.isTestPhase());
        if (!outputDir.exists()) {
            boolean b;
            if (log.isDebugEnabled()) {
                log.debug("[" + writer.getInputProtocol() + "] Create output directory " + outputDir);
            }
            if (!(b = outputDir.mkdirs())) {
                throw new IOException("Could not create directory " + outputDir);
            }
        }
        HashMap<String, Set<String>> directoryEntries = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> classpathEntries = new HashMap<String, Set<String>>();
        for (ChainedFileWriterEntry e : writer.getEntries()) {
            String input;
            HashMap<String, Set<String>> currentMap = e.isUseClassPath() ? classpathEntries : directoryEntries;
            LinkedHashSet<String> includes = (LinkedHashSet<String>)currentMap.get(input = e.getInputPath());
            if (includes == null) {
                includes = new LinkedHashSet<String>();
                currentMap.put(input, includes);
            }
            includes.add(e.getIncludePattern());
        }
        ChainedFileWriterData result = new ChainedFileWriterData();
        result.setFilesByRoot(new HashMap<File, List<File>>());
        result.setResourcesByFile(new HashMap<File, List<File>>());
        result.setOutputDirectory(outputDir);
        File extractDirectory = writer.getExtractDirectory(this.configuration.getExtractDirectory(), this.configuration.isTestPhase());
        this.grabFiles(extractDirectory, this.fileGrabberFromDirectory, directoryEntries, result);
        this.grabFiles(extractDirectory, this.fileGrabberFromClassPath, classpathEntries, result);
        return result;
    }

    protected void grabFiles(File extractDirectory, FileGrabber grabber, Map<String, Set<String>> entries, ChainedFileWriterData result) throws IOException {
        for (Map.Entry<String, Set<String>> entry : entries.entrySet()) {
            String inputDirectory = entry.getKey();
            Set<String> includePatterns = entry.getValue();
            grabber.addFilesToTreate(extractDirectory, inputDirectory, includePatterns, result);
        }
    }

    protected void checkInit(String method) throws IllegalStateException {
        if (this.configuration == null) {
            throw new IllegalStateException("Engine was not initialized! Can not access to " + method + " before the init method was invoked!");
        }
    }

    public static enum ModelFileWriterEntryType {
        ONLY_PROTOCOL_PATTERN("^([a-zA-Z]+)$"){

            @Override
            public ChainedFileWriter getWriter(DefaultChainedWriterEngine engine, String include, Matcher matcher) {
                String protocol;
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                Set<ChainedFileWriter> universe = engine.getAvailableWriters();
                ChainedFileWriter writer = engine.getWriterForInputProtocol(universe, protocol = matcher.group(1).toLowerCase(), conf.getModelType());
                if (writer == null) {
                    throw new IllegalArgumentException("could not find the writer named '" + protocol + "', use one of " + universe);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] writer = (" + writer + ")");
                }
                return writer;
            }

            @Override
            public ChainedFileWriterEntry newEntry(DefaultChainedWriterEngine engine, String include, Matcher matcher, ChainedFileWriter writer) {
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] detected pattern (" + this.name() + ")");
                }
                ChainedFileWriterEntry writerEntry = new ChainedFileWriterEntry(new File(conf.getBasedir(), conf.isTestPhase() ? writer.getDefaultTestInputDirectory() : writer.getDefaultInputDirectory()).getAbsolutePath(), writer.getDefaultIncludes());
                return writerEntry;
            }
        }
        ,
        NO_PROTOCOL_PATTERN_WITH_CLASSPATH("^classpath:([^:]+):([^:]+)$"){

            @Override
            public ChainedFileWriter getWriter(DefaultChainedWriterEngine engine, String include, Matcher matcher) {
                String modelType;
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                Set<ChainedFileWriter> universe = engine.getAvailableWriters();
                ChainedFileWriter writer = engine.getWriterForInclude(universe, include, modelType = conf.getModelType());
                if (writer == null) {
                    throw new IllegalArgumentException("could not find a writer for include " + include);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] writer = (" + writer + ")");
                }
                return writer;
            }

            @Override
            public ChainedFileWriterEntry newEntry(DefaultChainedWriterEngine engine, String include, Matcher matcher, ChainedFileWriter writer) {
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] detected pattern (" + this.name() + ")");
                }
                String inputPath = matcher.group(1);
                String includes = matcher.group(2);
                ChainedFileWriterEntry writerEntry = new ChainedFileWriterEntry(inputPath, includes, true);
                return writerEntry;
            }
        }
        ,
        NO_PROTOCOL_PATTERN("^([^:]+):([^:]+)$"){

            @Override
            public ChainedFileWriter getWriter(DefaultChainedWriterEngine engine, String include, Matcher matcher) {
                String modelType;
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                Set<ChainedFileWriter> universe = engine.getAvailableWriters();
                ChainedFileWriter writer = engine.getWriterForInclude(universe, include, modelType = conf.getModelType());
                if (writer == null) {
                    throw new IllegalArgumentException("could not find a writer for include " + include);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] writer = (" + writer + ")");
                }
                return writer;
            }

            @Override
            public ChainedFileWriterEntry newEntry(DefaultChainedWriterEngine engine, String include, Matcher matcher, ChainedFileWriter writer) {
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] detected pattern (" + this.name() + ")");
                }
                String inputPath = matcher.group(1);
                String includes = matcher.group(2);
                ChainedFileWriterEntry writerEntry = new ChainedFileWriterEntry(new File(conf.getBasedir(), inputPath).getAbsolutePath(), includes);
                return writerEntry;
            }
        }
        ,
        FULL_PATTERN_WITH_CLASSPATH("^classpath:(\\w+):([^:]+):([^:]+)$"){

            @Override
            public ChainedFileWriter getWriter(DefaultChainedWriterEngine engine, String include, Matcher matcher) {
                String protocol;
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                Set<ChainedFileWriter> universe = engine.getAvailableWriters();
                ChainedFileWriter writer = engine.getWriterForInputProtocol(universe, protocol = matcher.group(1).toLowerCase(), conf.getModelType());
                if (writer == null) {
                    throw new IllegalArgumentException("could not find the writer named '" + protocol + "', use one of " + universe);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] writer = (" + writer + ")");
                }
                return writer;
            }

            @Override
            public ChainedFileWriterEntry newEntry(DefaultChainedWriterEngine engine, String include, Matcher matcher, ChainedFileWriter writer) {
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] detected pattern (" + this.name() + ")");
                }
                String inputPath = matcher.group(2);
                String includes = matcher.group(3);
                ChainedFileWriterEntry writerEntry = new ChainedFileWriterEntry(inputPath, includes, true);
                return writerEntry;
            }
        }
        ,
        FULL_PATTERN("^(\\w+):([^:]+):([^:]+)$"){

            @Override
            public ChainedFileWriter getWriter(DefaultChainedWriterEngine engine, String include, Matcher matcher) {
                String protocol;
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                Set<ChainedFileWriter> universe = engine.getAvailableWriters();
                ChainedFileWriter writer = engine.getWriterForInputProtocol(universe, protocol = matcher.group(1).toLowerCase(), conf.getModelType());
                if (writer == null) {
                    throw new IllegalArgumentException("could not find the writer named '" + protocol + "', use one of " + universe);
                }
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] writer = (" + writer + ")");
                }
                return writer;
            }

            @Override
            public ChainedFileWriterEntry newEntry(DefaultChainedWriterEngine engine, String include, Matcher matcher, ChainedFileWriter writer) {
                ChainedFileWriterConfiguration conf = engine.getConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug("[" + include + "] detected pattern (" + this.name() + ")");
                }
                String inputPath = matcher.group(2);
                String includes = matcher.group(3);
                ChainedFileWriterEntry writerEntry = new ChainedFileWriterEntry(new File(conf.getBasedir(), inputPath).getAbsolutePath(), includes);
                return writerEntry;
            }
        };

        private final Pattern pattern;

        private ModelFileWriterEntryType(String pattern) {
            this.pattern = Pattern.compile(pattern);
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Matcher getMatcher(String include) {
            Matcher matcher = this.getPattern().matcher(include);
            return matcher.matches() ? matcher : null;
        }

        public abstract ChainedFileWriterEntry newEntry(DefaultChainedWriterEngine var1, String var2, Matcher var3, ChainedFileWriter var4);

        public abstract ChainedFileWriter getWriter(DefaultChainedWriterEngine var1, String var2, Matcher var3);
    }
}

