/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.tagvalue;

import com.google.common.collect.ImmutableMap;
import io.ultreia.java4all.util.SortedProperties;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TagValuesStore {
    private final SortedProperties store = new SortedProperties();

    public static String getModelTagValueKey(String modelName, String name) {
        return String.format("%s.%s.%s.%s", "model", modelName, "tagValue", name);
    }

    public static String getPackageTagValueKey(String packageName, String name) {
        return String.format("%s.%s.%s.%s", "package", packageName, "tagValue", name);
    }

    public static String getClassifierTagValueKey(String classifierName, String name) {
        return String.format("%s.%s.%s.%s", classifierName, "class", "tagValue", name);
    }

    public static String getAttributeTagValueKey(String classifierName, String attributeName, String name) {
        return String.format("%s.%s.%s.%s.%s", classifierName, "attribute", attributeName, "tagValue", name);
    }

    public String getModelTagValue(String modelName, String name) {
        return this.store.getProperty(TagValuesStore.getModelTagValueKey(modelName, name));
    }

    public String getPackageTagValue(String packageName, String name) {
        return this.store.getProperty(TagValuesStore.getPackageTagValueKey(packageName, name));
    }

    public String getClassifierTagValue(String classifierName, String name) {
        return this.store.getProperty(TagValuesStore.getClassifierTagValueKey(classifierName, name));
    }

    public String getAttributeTagValue(String classifierName, String attributeName, String name) {
        return this.store.getProperty(TagValuesStore.getAttributeTagValueKey(classifierName, attributeName, name));
    }

    public boolean hasModelTagValue(String modelName, String name) {
        return null != this.store.getProperty(TagValuesStore.getModelTagValueKey(modelName, name));
    }

    public void setModelTagValue(String modelName, String name, String value) {
        this.store.setProperty(TagValuesStore.getModelTagValueKey(modelName, name), value);
    }

    public void removeModelTagValue(String modelName, String name) {
        this.store.setProperty(TagValuesStore.getModelTagValueKey(modelName, name), null);
    }

    public void setPackageTagValue(String packageName, String name, String value) {
        this.store.setProperty(TagValuesStore.getPackageTagValueKey(packageName, name), value);
    }

    public void setClassifierTagValue(String classifierName, String name, String value) {
        this.store.setProperty(TagValuesStore.getClassifierTagValueKey(classifierName, name), value);
    }

    public void setAttributeTagValue(String classifierName, String attributeName, String name, String value) {
        this.store.setProperty(TagValuesStore.getAttributeTagValueKey(classifierName, attributeName, name), value);
    }

    public void removePackageTagValue(String packageName, String name) {
        this.store.setProperty(TagValuesStore.getPackageTagValueKey(packageName, name), null);
    }

    public void removeClassifierTagValue(String classifierName, String name) {
        this.store.setProperty(TagValuesStore.getClassifierTagValueKey(classifierName, name), null);
    }

    public void removeAttributeTagValue(String classifierName, String attributeName, String name) {
        this.store.setProperty(TagValuesStore.getAttributeTagValueKey(classifierName, attributeName, name), null);
    }

    public boolean hasPackageTagValue(String packageName, String name) {
        return null != this.store.getProperty(TagValuesStore.getPackageTagValueKey(packageName, name), null);
    }

    public boolean hasClassifierTagValue(String classifierName, String name) {
        return null != this.store.getProperty(TagValuesStore.getClassifierTagValueKey(classifierName, name), null);
    }

    public boolean hasAttributeTagValue(String classifierName, String attributeName, String name) {
        return null != this.store.getProperty(TagValuesStore.getAttributeTagValueKey(classifierName, attributeName, name), null);
    }

    public Map<String, String> getPackageTagValues(String packageName) {
        String prefix = String.format("%s.%s.%s.", "package", packageName, "tagValue");
        return this.getTagValues(prefix);
    }

    public Map<String, String> getClassifierTagValues(String classifierName) {
        String prefix = String.format("%s.%s.%s.", classifierName, "class", "tagValue");
        return this.getTagValues(prefix);
    }

    public Map<String, String> getAttributeTagValues(String classifierName, String attributeName) {
        String prefix = String.format("%s.%s.%s.%s.", classifierName, "attribute", attributeName, "tagValue");
        return this.getTagValues(prefix);
    }

    public Properties getStore() {
        return this.store;
    }

    public Map<String, String> getModelTagValues(String modelName) {
        String prefix = String.format("%s.%s.%s.", "model", modelName, "tagValue");
        return this.getTagValues(prefix);
    }

    public Map<String, String> getTagValues(String prefix) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int length = prefix.length();
        for (String propertyName : this.store.stringPropertyNames()) {
            if (!propertyName.startsWith(prefix)) continue;
            builder.put((Object)propertyName.substring(length), (Object)this.store.getProperty(propertyName));
        }
        return builder.build();
    }

    public List<String> getPropertyList(String prefix) {
        return null;
    }
}

