/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.state.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.eugene.models.state.StateModelComplexState;
import org.nuiton.eugene.models.state.StateModelSimpleState;
import org.nuiton.eugene.models.state.StateModelState;
import org.nuiton.eugene.models.state.StateModelTransition;
import org.nuiton.eugene.models.state.xml.StateModelStateImpl;
import org.nuiton.eugene.models.state.xml.StateModelTransitionImpl;

public class StateModelComplexeStateImpl
extends StateModelStateImpl
implements StateModelComplexState {
    protected Map<String, StateModelState> mapState = new HashMap<String, StateModelState>();

    public void addState(StateModelState state) {
        this.mapState.put(state.getName(), state);
    }

    @Override
    public Collection<StateModelState> getStates() {
        return this.mapState.values();
    }

    void correctTransitionNameToInstance(StateModelComplexeStateImpl parent) {
        for (StateModelState stateModelState : this.mapState.values()) {
            StateModelState state = stateModelState;
            if (state instanceof StateModelComplexeStateImpl) {
                ((StateModelComplexeStateImpl)state).correctTransitionNameToInstance(this);
                continue;
            }
            for (StateModelTransition tr : state.getTransitions()) {
                StateModelTransitionImpl tri = (StateModelTransitionImpl)tr;
                String name = tri.getStateName();
                if (this.getState(name) != null) {
                    tri.setState(this.getState(name));
                    continue;
                }
                if (parent == null || parent.getState(name) == null) continue;
                tri.setState(parent.getState(name));
            }
        }
    }

    StateModelState getState(String stateName) {
        return this.mapState.get(stateName);
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public StateModelState getInitialState() {
        StateModelState response = null;
        for (StateModelState stateModelState : this.mapState.values()) {
            StateModelSimpleState simpleState;
            StateModelState state = stateModelState;
            if (state.isComplex() || !(simpleState = (StateModelSimpleState)state).isInitial()) continue;
            response = simpleState.getTransitions().get(0).getDestinationState();
        }
        return response;
    }
}

