/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.ObjectModelUMLModifier;
import org.nuiton.eugene.models.object.xml.ObjectModelElementImpl;

public class ObjectModelParameterImpl
extends ObjectModelElementImpl
implements ObjectModelParameter {
    public static final String PROPERTY_ORDERED = "ordered";
    private static Set<ObjectModelModifier> authorizedModifiers;
    protected String type;
    protected int minMultiplicity = 1;
    protected int maxMultiplicity = 1;
    protected String defaultValue;

    public ObjectModelParameterImpl() {
        this.addModifier(ObjectModelUMLModifier.UNIQUE);
    }

    protected void mergeFrom(ObjectModelParameterImpl source) {
        super.mergeFrom(source);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    protected Set<ObjectModelModifier> getAuthorizedModifiers() {
        if (authorizedModifiers == null) {
            authorizedModifiers = ImmutableSet.of((Object)ObjectModelUMLModifier.UNIQUE, (Object)ObjectModelUMLModifier.ORDERED, (Object)ObjectModelUMLModifier.UNIQUE);
        }
        return authorizedModifiers;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMinMultiplicity(int minMultiplicity) {
        this.minMultiplicity = minMultiplicity;
    }

    public void setMaxMultiplicity(int maxMultiplicity) {
        this.maxMultiplicity = maxMultiplicity;
    }

    public void setOrdering(String ordering) {
        this.setOrdered(PROPERTY_ORDERED.equals(ordering));
    }

    public void setUnique(boolean unique) {
        this.addOrRemoveModifier(ObjectModelUMLModifier.UNIQUE, unique);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getMinMultiplicity() {
        return this.minMultiplicity;
    }

    @Override
    public int getMaxMultiplicity() {
        return this.maxMultiplicity;
    }

    @Override
    public boolean isOrdered() {
        return this.modifiers.contains(ObjectModelUMLModifier.ORDERED);
    }

    public void setOrdered(boolean ordered) {
        this.addOrRemoveModifier(ObjectModelUMLModifier.ORDERED, ordered);
    }

    @Override
    public boolean isUnique() {
        return this.modifiers.contains(ObjectModelUMLModifier.UNIQUE);
    }

    public String toString() {
        return this.getType() + " " + this.getName() + "<<" + this.getStereotypes() + ">> tagvalue: " + this.getTagValues();
    }
}

