/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplTagValue;

public class ObjectModelPackageImpl
implements ObjectModelPackage {
    private static final Logger log = LogManager.getLogger(ObjectModelPackageImpl.class);
    protected ObjectModelImpl objectModelImpl;
    protected boolean extern;
    protected String name;
    protected final Predicate<ObjectModelClassifier> IS_PACKAGE_NAME_EQUALS_PREDICATE;
    protected final Predicate<ObjectModelPackage> IS_PACKAGE_NAME_STARTS_WITH_PREDICATE;
    protected int numberOfSubPackages;
    protected ObjectModelPackage parentPackage;
    protected String documentation;
    protected Set<String> stereotypes;
    protected Map<String, String> tagValues;
    protected List<String> comments;

    public ObjectModelPackageImpl() {
        this.IS_PACKAGE_NAME_EQUALS_PREDICATE = new PackageNameEqualsPredicate(this.name);
        this.IS_PACKAGE_NAME_STARTS_WITH_PREDICATE = new PackageNameStartsWithPredicate(this.name + ".");
        this.stereotypes = new HashSet<String>();
        this.tagValues = new HashMap<String, String>();
        this.comments = new ArrayList<String>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfSubPackages() {
        return this.numberOfSubPackages;
    }

    @Override
    public ObjectModelPackage getParentPackage() {
        return this.parentPackage;
    }

    @Override
    public String getDescription() {
        return this.getDocumentation().substring(0, this.getDocumentation().indexOf("--"));
    }

    @Override
    public String getSourceDocumentation() {
        return this.getDocumentation().substring(this.getDocumentation().indexOf("--") + 2);
    }

    @Override
    public Set<String> getStereotypes() {
        return this.stereotypes;
    }

    @Override
    public boolean hasStereotype(String stereotypeName) {
        return this.stereotypes.contains(stereotypeName);
    }

    @Override
    public void addStereotype(String stereotype) {
        this.stereotypes.add(stereotype);
    }

    @Override
    public void removeStereotype(String stereotype) {
        this.stereotypes.remove(stereotype);
    }

    @Override
    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    @Override
    public String getTagValue(String tagValue) {
        return tagValue == null ? null : this.tagValues.get(tagValue);
    }

    @Override
    public boolean hasTagValue(String tagValue) {
        return this.tagValues.containsKey(tagValue);
    }

    @Override
    public void addTagValue(String tagValue, String value) {
        String oldValue = this.getTagValue(tagValue);
        if (StringUtils.isNotEmpty((CharSequence)oldValue)) {
            if (oldValue.equals(value)) {
                return;
            }
            log.warn("Replace tagValue '" + tagValue + "' (old:" + oldValue + ", new: " + value + ")");
        }
        this.tagValues.put(tagValue, value);
    }

    @Override
    public void removeTagValue(String tagvalue) {
        this.tagValues.remove(tagvalue);
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public Iterable<ObjectModelPackage> getPackages() {
        return this.objectModelImpl.getPackages().stream().filter(this.IS_PACKAGE_NAME_STARTS_WITH_PREDICATE).collect(Collectors.toList());
    }

    @Override
    public boolean hasPackage(String packageName) {
        ObjectModelPackage aPackage = this.objectModelImpl.getPackage(packageName);
        return aPackage != null && this.IS_PACKAGE_NAME_STARTS_WITH_PREDICATE.test(aPackage);
    }

    @Override
    public Iterable<ObjectModelClassifier> getClassifiers() {
        return this.objectModelImpl.getClassifiers().stream().filter(this.IS_PACKAGE_NAME_EQUALS_PREDICATE).collect(Collectors.toList());
    }

    @Override
    public ObjectModelClassifier getClassifier(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = this.objectModelImpl.getClassifiers().stream().filter(predicate).collect(Collectors.toList());
        return (ObjectModelClassifier)Iterables.getFirst((Iterable)filter, null);
    }

    @Override
    public Iterable<ObjectModelClass> getClasses() {
        return this.objectModelImpl.getClasses().stream().filter(this.IS_PACKAGE_NAME_EQUALS_PREDICATE).collect(Collectors.toList());
    }

    @Override
    public ObjectModelClass getClass(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = this.objectModelImpl.getClasses().stream().filter(predicate).collect(Collectors.toList());
        return (ObjectModelClass)Iterables.getFirst((Iterable)filter, null);
    }

    @Override
    public boolean hasClass(String simpleName) {
        return false;
    }

    @Override
    public Iterable<ObjectModelInterface> getInterfaces() {
        return this.objectModelImpl.getInterfaces().stream().filter(this.IS_PACKAGE_NAME_EQUALS_PREDICATE).collect(Collectors.toList());
    }

    @Override
    public ObjectModelInterface getInterface(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = this.objectModelImpl.getInterfaces().stream().filter(predicate).collect(Collectors.toList());
        return (ObjectModelInterface)Iterables.getFirst((Iterable)filter, null);
    }

    @Override
    public Iterable<ObjectModelEnumeration> getEnumerations() {
        return this.objectModelImpl.getEnumerations().stream().filter(this.IS_PACKAGE_NAME_EQUALS_PREDICATE).collect(Collectors.toList());
    }

    @Override
    public ObjectModelEnumeration getEnumeration(String simpleName) {
        Predicate<ObjectModelClassifier> predicate = this.newClassifierNameEquals(simpleName);
        Iterable filter = this.objectModelImpl.getEnumerations().stream().filter(predicate).collect(Collectors.toList());
        return (ObjectModelEnumeration)Iterables.getFirst((Iterable)filter, null);
    }

    public boolean isExtern() {
        return this.extern;
    }

    public void setExtern(boolean extern) {
        this.extern = extern;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public ObjectModelImplRef addStereotype(ObjectModelImplRef stereotype) {
        if (stereotype == null) {
            return new ObjectModelImplRef();
        }
        this.stereotypes.add(stereotype.getName());
        return stereotype;
    }

    public ObjectModelImplTagValue addTagValue(ObjectModelImplTagValue tagValue) {
        if (tagValue == null) {
            return new ObjectModelImplTagValue();
        }
        this.addTagValue(tagValue.getName(), tagValue.getValue());
        return tagValue;
    }

    public void setObjectModelImpl(ObjectModelImpl objectModelImpl) {
        this.objectModelImpl = objectModelImpl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPackage(ObjectModelPackage parentPackage) {
        this.parentPackage = parentPackage;
    }

    public void postInit() {
        this.numberOfSubPackages = this.name.split("\\.").length;
    }

    protected Predicate<ObjectModelClassifier> newClassifierNameEquals(String simpleName) {
        return this.IS_PACKAGE_NAME_EQUALS_PREDICATE.and(new SimpleNameEqualsPredicate(simpleName));
    }

    protected void mergeFrom(ObjectModelPackageImpl source) {
        Object description = "";
        Object sourceDoc = "";
        if (this.documentation != null) {
            description = (String)description + this.getDescription();
            if (this.documentation.contains("--")) {
                sourceDoc = (String)sourceDoc + this.getSourceDocumentation();
            }
        }
        if (source.documentation != null) {
            if (!((String)description).equals("")) {
                description = (String)description + " - ";
            }
            description = (String)description + source.getDescription();
            if (source.documentation.contains("--")) {
                if (!((String)sourceDoc).equals("")) {
                    sourceDoc = (String)sourceDoc + " - ";
                }
                sourceDoc = (String)sourceDoc + source.getSourceDocumentation();
            }
        }
        if (!((String)description).equals("") || !((String)sourceDoc).equals("")) {
            this.documentation = (String)description + "--" + (String)sourceDoc;
        }
        for (String comment : source.getComments()) {
            if (this.comments.contains(comment)) continue;
            this.comments.add(comment);
        }
        for (String stereotype : source.getStereotypes()) {
            if (this.getStereotypes().contains(stereotype)) continue;
            this.stereotypes.add(stereotype);
        }
        for (String tagName : source.getTagValues().keySet()) {
            if (this.getTagValues().containsKey(tagName)) continue;
            this.tagValues.put(tagName, source.getTagValue(tagName));
        }
    }

    protected static class PackageNameStartsWithPredicate
    implements Predicate<ObjectModelPackage> {
        protected final String name;

        public PackageNameStartsWithPredicate(String name) {
            this.name = name;
        }

        @Override
        public boolean test(ObjectModelPackage input) {
            return input.getName().startsWith(this.name);
        }
    }

    protected static class PackageNameEqualsPredicate
    implements Predicate<ObjectModelClassifier> {
        protected final String name;

        public PackageNameEqualsPredicate(String name) {
            this.name = name;
        }

        @Override
        public boolean test(ObjectModelClassifier input) {
            return input.getPackageName().equals(this.name);
        }
    }

    protected static class SimpleNameEqualsPredicate
    implements Predicate<ObjectModelClassifier> {
        protected final String name;

        public SimpleNameEqualsPredicate(String name) {
            this.name = name;
        }

        @Override
        public boolean test(ObjectModelClassifier input) {
            return input.getName().equals(this.name);
        }
    }
}

