/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.xml.ObjectModelImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplTagValue;

public abstract class ObjectModelElementImpl
implements ObjectModelElement {
    private static final Logger log = LogManager.getLogger(ObjectModelElementImpl.class);
    protected ObjectModelImpl objectModelImpl;
    protected ObjectModelElement declaringElement;
    protected String name;
    protected String documentation;
    protected Map<String, String> tagValues = new HashMap<String, String>();
    protected List<String> comments = new ArrayList<String>();
    protected Set<ObjectModelModifier> modifiers = new HashSet<ObjectModelModifier>();

    protected void mergeFrom(ObjectModelElementImpl source) {
        this.tagValues.putAll(source.getTagValues());
        this.comments.addAll(source.getComments());
        this.modifiers.addAll(source.modifiers);
    }

    public void setObjectModelImpl(ObjectModelImpl objectModelImpl) {
        this.objectModelImpl = objectModelImpl;
    }

    public void setDeclaringElement(ObjectModelElement declaringElement) {
        this.declaringElement = declaringElement;
    }

    public ObjectModelImpl getModel() {
        if (this.objectModelImpl != null) {
            return this.objectModelImpl;
        }
        if (this.declaringElement != null) {
            return ((ObjectModelElementImpl)this.declaringElement).getModel();
        }
        return null;
    }

    public void postInit() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public ObjectModelImplRef addStereotype(ObjectModelImplRef stereotype) {
        if (stereotype == null) {
            return new ObjectModelImplRef();
        }
        this.addStereotype(stereotype.getName());
        return stereotype;
    }

    public ObjectModelImplTagValue addTagValue(ObjectModelImplTagValue tagValue) {
        if (tagValue == null) {
            return new ObjectModelImplTagValue();
        }
        this.addTagValue(tagValue.getName(), tagValue.getValue());
        return tagValue;
    }

    protected void addOrRemoveModifier(ObjectModelModifier modifier, boolean add) {
        if (add) {
            this.addModifier(modifier);
        } else {
            this.removeModifier(modifier);
        }
    }

    public void addModifier(ObjectModelModifier ... modifiers) {
        if (modifiers == null || modifiers.length == 1 && modifiers[0] == null) {
            throw new IllegalArgumentException("Modifier is null");
        }
        for (ObjectModelModifier modifier : modifiers) {
            if (!this.getAuthorizedModifiers().contains(modifier)) {
                throw new UnsupportedOperationException("Forbidden modifier: " + modifier.getName());
            }
            this.modifiers.add(modifier);
        }
    }

    protected void removeModifiers(Iterable<? extends ObjectModelModifier> modifiers) {
        this.removeModifier((ObjectModelModifier[])Iterables.toArray(modifiers, ObjectModelModifier.class));
    }

    protected void removeModifier(ObjectModelModifier ... modifiers) {
        for (ObjectModelModifier modifier : modifiers) {
            this.modifiers.remove(modifier);
        }
    }

    protected abstract Set<ObjectModelModifier> getAuthorizedModifiers();

    public void setStatic(boolean isStatic) {
        this.addOrRemoveModifier(ObjectModelJavaModifier.STATIC, isStatic);
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ObjectModelElement getDeclaringElement() {
        return this.declaringElement;
    }

    @Override
    public String getDocumentation() {
        String doc;
        if (this.documentation == null && this.hasTagValue(EugeneCoreTagValues.Store.documentation.getName()) && StringUtils.isNotEmpty((CharSequence)(doc = this.getTagValue(EugeneCoreTagValues.Store.documentation.getName())))) {
            this.documentation = doc;
        }
        return this.documentation;
    }

    @Override
    public String getDescription() {
        return this.getDocumentation().substring(0, this.getDocumentation().indexOf("--"));
    }

    @Override
    public String getSourceDocumentation() {
        return this.getDocumentation().substring(this.getDocumentation().indexOf("--") + 2);
    }

    @Override
    public Set<String> getStereotypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : this.tagValues.entrySet()) {
            if (!"true".equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public boolean hasStereotype(String stereotypeName) {
        return this.tagValues.containsKey(stereotypeName);
    }

    @Override
    public void addStereotype(String stereotype) {
        this.tagValues.put(stereotype, "true");
    }

    @Override
    public void removeStereotype(String stereotype) {
        this.tagValues.remove(stereotype);
    }

    @Override
    public Map<String, String> getTagValues() {
        return this.tagValues;
    }

    @Override
    public String getTagValue(String tagValue) {
        return tagValue == null ? null : this.tagValues.get(tagValue);
    }

    @Override
    public boolean hasTagValue(String tagValue) {
        return this.tagValues.containsKey(tagValue);
    }

    @Override
    public void removeTagValue(String tagvalue) {
        this.tagValues.remove(tagvalue);
    }

    @Override
    public void addTagValue(String tagValue, String value) {
        String oldValue = this.getTagValue(tagValue);
        if (StringUtils.isNotEmpty((CharSequence)oldValue)) {
            if (oldValue.equals(value)) {
                return;
            }
            log.warn("Replace tagValue '" + tagValue + "' (old:" + oldValue + ", new: " + value + ")");
        }
        this.tagValues.put(tagValue, value);
    }

    @Override
    public boolean isStatic() {
        return this.modifiers.contains(ObjectModelJavaModifier.STATIC);
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }
}

