/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.models.object.xml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.xml.ExternalCacheExtension;
import org.nuiton.eugene.models.object.xml.ObjectModelAttributeImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelClassifierImpl;
import org.nuiton.eugene.models.object.xml.ObjectModelImplRef;
import org.nuiton.eugene.models.object.xml.ObjectModelImplSuperClassRef;

public class ObjectModelClassImpl
extends ObjectModelClassifierImpl
implements ObjectModelClass {
    private static final Logger log = LogManager.getLogger(ObjectModelClassImpl.class);
    private static Set<ObjectModelModifier> authorizedModifiers;
    protected List<ObjectModelClass> superclasses;
    protected Map<ObjectModelClass, String> superclassesDiscriminators = new HashMap<ObjectModelClass, String>();
    protected List<ObjectModelImplRef> superclassesRefs = new ArrayList<ObjectModelImplRef>();
    protected List<ObjectModelClass> specialisations;
    protected List<ObjectModelClassifier> innerClasses;

    @Override
    protected Set<ObjectModelModifier> getAuthorizedModifiers() {
        if (authorizedModifiers == null) {
            HashSet modifiers = Sets.newHashSet((Object[])new ObjectModelModifier[]{ObjectModelJavaModifier.ABSTRACT, ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.FINAL, ObjectModelJavaModifier.STRICTFP});
            modifiers.addAll(ObjectModelJavaModifier.visibilityModifiers);
            authorizedModifiers = ImmutableSet.copyOf((Collection)modifiers);
        }
        return authorizedModifiers;
    }

    public void clearSuperclasses() {
        this.superclasses = null;
        this.superclassesRefs.clear();
    }

    public void addSuperclass(ObjectModelImplRef ref) {
        this.superclassesRefs.add(ref);
        this.superclasses = null;
        this.superclassesDiscriminators = null;
    }

    public void addInnerClassifier(ObjectModelClassifierImpl innerClass) {
        innerClass.setDeclaringElement(this);
        innerClass.setInner(true);
        if (this.innerClasses == null) {
            this.innerClasses = new ArrayList<ObjectModelClassifier>();
        }
        this.innerClasses.add(innerClass);
    }

    public void setAbstract(boolean abstractz) {
        this.addOrRemoveModifier(ObjectModelJavaModifier.ABSTRACT, abstractz);
    }

    @Override
    public Collection<ObjectModelClass> getSuperclasses() {
        if (this.superclasses == null) {
            this.superclasses = new ArrayList<ObjectModelClass>();
            this.superclassesDiscriminators = new LinkedHashMap<ObjectModelClass, String>();
            for (ObjectModelImplRef superclassesRef : this.superclassesRefs) {
                ObjectModelClass superclass;
                ObjectModelImplSuperClassRef ref = (ObjectModelImplSuperClassRef)superclassesRef;
                if (log.isDebugEnabled()) {
                    log.debug("Superclass ref for " + this.getQualifiedName() + " : " + ref.getName());
                }
                if ((superclass = this.objectModelImpl.getClass(ref.getName())) == null) {
                    ExternalCacheExtension cache = this.objectModelImpl.getExtension("externalClassifiers", ExternalCacheExtension.class);
                    superclass = cache.getCache(ref, ObjectModelClassImpl.class);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Superclass for " + this.getQualifiedName() + " : " + superclass.getQualifiedName());
                }
                this.superclasses.add(superclass);
                this.superclassesDiscriminators.put(superclass, ref.getDiscriminator());
            }
        }
        return this.superclasses;
    }

    @Override
    public Collection<ObjectModelClassifier> getInnerClassifiers() {
        return this.innerClasses;
    }

    @Override
    public String getDiscriminator(ObjectModelClass superclass) {
        if (this.superclassesDiscriminators == null) {
            this.getSuperclasses();
        }
        return this.superclassesDiscriminators.get(superclass);
    }

    @Override
    public Collection<ObjectModelClass> getSpecialisations() {
        if (this.specialisations == null) {
            this.specialisations = new ArrayList<ObjectModelClass>();
            for (ObjectModelClass o : this.objectModelImpl.getClasses()) {
                if (!o.getSuperclasses().contains(this)) continue;
                this.specialisations.add(o);
            }
        }
        return this.specialisations;
    }

    @Override
    public Collection<ObjectModelClass> getSpecialisations(String discriminator) {
        ArrayList<ObjectModelClass> discriminatedSpecialisations = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass candidateClass : this.getSpecialisations()) {
            if (!discriminator.equals(candidateClass.getDiscriminator(this))) continue;
            discriminatedSpecialisations.add(candidateClass);
        }
        return discriminatedSpecialisations;
    }

    @Override
    public boolean isAbstract() {
        return this.modifiers.contains(ObjectModelJavaModifier.ABSTRACT);
    }

    @Override
    public Collection<ObjectModelOperation> getAllOtherOperations(boolean distinct) {
        Collection<ObjectModelOperation> result = this.getAllInterfaceOperations(distinct);
        this.getAllSuperclassOperations(result);
        return result;
    }

    @Override
    public Collection<ObjectModelOperation> getAllSuperclassOperations(boolean distinct) {
        AbstractCollection result = distinct ? new HashSet() : new LinkedList();
        this.getAllSuperclassOperations(result);
        return result;
    }

    protected Collection<ObjectModelOperation> getAllSuperclassOperations(Collection<ObjectModelOperation> result) {
        for (ObjectModelClass o : this.getSuperclasses()) {
            ObjectModelClassImpl clazz = (ObjectModelClassImpl)o;
            result.addAll(clazz.getOperations());
            clazz.getAllSuperclassOperations(result);
            clazz.getAllInterfaceOperations(result);
        }
        return result;
    }

    @Override
    public Collection<ObjectModelAttribute> getAllOtherAttributes() {
        Collection<ObjectModelAttribute> result = this.getAllInterfaceAttributes();
        this.getAllOtherAttributes(result);
        return result;
    }

    protected Collection<ObjectModelAttribute> getAllOtherAttributes(Collection<ObjectModelAttribute> result) {
        for (ObjectModelClass o : this.getSuperclasses()) {
            ObjectModelClassImpl clazz = (ObjectModelClassImpl)o;
            result.addAll(clazz.getAttributes());
            clazz.getAllOtherAttributes(result);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("class ").append(this.getQualifiedName()).append("<<").append(this.getStereotypes()).append(">> tagvalue: ").append(this.getTagValues()).append(" ");
        result.append("extends ");
        Iterator<ObjectModelClassifier> i = this.getSuperclasses().iterator();
        while (i.hasNext()) {
            result.append(((ObjectModelClassifier)i.next()).getName());
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append("implements ");
        i = this.getInterfaces().iterator();
        while (i.hasNext()) {
            result.append(i.next().getName());
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    protected void mergeFrom(ObjectModelClassImpl source) {
        super.mergeFrom(source);
        source.getAttributes().stream().map(objectModelAttribute -> (ObjectModelAttributeImpl)objectModelAttribute).forEach(this::addAttribute);
        source.superclassesRefs.forEach(superclassRef -> {
            if (!this.contains((Collection<?>)this.superclassesRefs, (ObjectModelImplRef)superclassRef)) {
                this.superclassesRefs.add((ObjectModelImplRef)superclassRef);
            }
            this.superclasses = null;
        });
    }
}

